package com.zoyi.channel.plugin.android.selector;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.store.BotStore;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.ManagerStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.util.ResUtils;

/**
 * Created by mika on 2018. 6. 18..
 */

public class ProfileSelector extends BaseSelector {

  @Nullable
  public static Person getPerson(@Nullable String personType, @Nullable String personId) {
    if (personType == null) {
      return null;
    }

    switch (personType) {
      case Const.MANAGER:
        return Store.getInstance(ManagerStore.class).get(personId);

      case Const.BOT:
        return Store.getInstance(BotStore.class).get(personId);

      default:
        return null;
    }
  }

  @Nullable
  public static ProfileEntity getHostProfile(@Nullable String personType, @Nullable String personId) {
    ProfileEntity entity = getPerson(personType, personId);

    if (entity != null) {
      return entity;
    }
    return Store.getInstance(ChannelStore.class).get();
  }

  @NonNull
  public static String getPersonName(String personType, String personId) {
    ProfileEntity entity = getHostProfile(personType, personId);

    if (entity == null || entity.getName() == null) {
      return ResUtils.getUnknown();
    }

    return entity.getName();
  }
}
