/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageSendListener;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.MediaType;
import com.zoyi.okhttp3.MultipartBody;
import com.zoyi.okhttp3.RequestBody;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ChatManager {
    @Nullable
    private static ChatManager chatManager;
    private boolean isMessageSending = false;
    private boolean released = false;
    private ArrayList<OnMessageSendListener> listeners;
    private Deque<SendingMessageItem> sendingItems = new LinkedList<SendingMessageItem>();
    private LongSparseArray<SendingMessageItem> failedItems = new LongSparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChatManager get() {
        if (chatManager != null) return chatManager;
        Class<ChatManager> clazz = ChatManager.class;
        synchronized (ChatManager.class) {
            if (chatManager != null) return chatManager;
            chatManager = new ChatManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return chatManager;
        }
    }

    private ChatManager() {
        this.listeners = new ArrayList();
    }

    public void addListener(OnMessageSendListener listener) {
        if (this.listeners != null && listener != null && this.listeners.indexOf(listener) < 0) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(OnMessageSendListener listener) {
        if (this.listeners != null && listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void send(SendingMessageItem item) {
        this.send(ListUtils.newArrayList(item));
    }

    public void send(List<SendingMessageItem> items) {
        if (!this.released) {
            this.sendingItems.addAll(items);
            this.sendWaitingMessage();
        }
    }

    public void sendImmediately(SendingMessageItem item) {
        if (!this.released) {
            this.sendingItems.addFirst(item);
            this.sendWaitingMessage();
        }
    }

    private void sendWaitingMessage() {
        if (!this.isMessageSending) {
            while (this.sendingItems.size() > 0) {
                SendingMessageItem item = this.sendingItems.poll();
                if (item == null || item.getContentType() == ContentType.NONE) continue;
                this.isMessageSending = true;
                this.routeItem(item);
                break;
            }
        }
    }

    public void updateFailedMessages(List<SendingMessageItem> items) {
        for (SendingMessageItem item : items) {
            this.failedItems.put(item.getPrimaryKey().longValue(), (Object)item);
        }
    }

    public void read(@Nullable String chatId) {
        if (chatId != null) {
            ChannelApiManager.call(ChannelApiManager.get().read(chatId), new RestSubscriber());
        }
    }

    private void routeItem(SendingMessageItem item) {
        switch (item.getContentType()) {
            case FILE: {
                this.sendMediaFileMessage(item);
                break;
            }
            case TEXT: {
                this.sendTextMessage(item);
                break;
            }
            case ACTION: {
                this.processAction(item);
            }
        }
    }

    private void processAction(SendingMessageItem item) {
        String actionType = item.getActionType();
        ActionButton actionButton = item.getActionButton();
        if (actionType != null && actionButton != null) {
            block6 : switch (actionType) {
                case "userChat.solve": 
                case "userChat.close": {
                    switch (actionButton.getKey()) {
                        case "close": {
                            this.closeChat(item);
                            break block6;
                        }
                        case "like": {
                            this.reviewChat(item, "like");
                            break block6;
                        }
                        case "dislike": {
                            this.reviewChat(item, "dislike");
                            break block6;
                        }
                    }
                    this.submitMessageAction(item);
                    break;
                }
                case "supportBot": {
                    this.submitSupportBotAction(item);
                    break;
                }
                case "select": {
                    this.submitMessageAction(item);
                    break;
                }
                default: {
                    this.submitMessageAction(item);
                }
            }
        }
    }

    private void sendTextMessage(SendingMessageItem item) {
        String chatId = item.getChatId();
        if (chatId != null) {
            RequestBody body = RequestUtils.form().set("message", item.getText()).set("requestId", item.getRequestId()).create();
            ChannelApiManager.call(ChannelApiManager.get().sendMessage(chatId, body), this.createMessageSubscriber(item));
        }
    }

    private void sendMediaFileMessage(SendingMessageItem item) {
        String chatId = item.getChatId();
        if (chatId != null) {
            MultipartBody.Part body = RequestUtils.makeMultipart(item.getFilePath());
            RequestBody timestamp = RequestBody.create((MediaType)MediaType.parse((String)"text/plane"), (String)item.getRequestId());
            if (body == null) {
                this.onSendFail(new Exception("Not supported type"), item);
                return;
            }
            ChannelApiManager.call(ChannelApiManager.get().uploadFile(chatId, body, timestamp), this.createMessageSubscriber(item));
        }
    }

    private void submitMessageAction(SendingMessageItem item) {
        String chatId = item.getChatId();
        ActionButton actionButton = item.getActionButton();
        if (chatId != null && actionButton != null) {
            HashMap<String, String> submit = new HashMap<String, String>();
            submit.put("id", actionButton.getMessage().getId());
            submit.put("key", actionButton.getKey());
            RequestBody body = RequestUtils.form().set("message", item.getText()).set("requestId", item.getRequestId()).set("submit", submit).create();
            ChannelApiManager.call(ChannelApiManager.get().sendMessage(chatId, body), this.createMessageSubscriber(item));
        }
    }

    private void closeChat(SendingMessageItem item) {
        String chatId = item.getChatId();
        ActionButton actionButton = item.getActionButton();
        if (chatId != null && actionButton != null) {
            ChannelApiManager.call(ChannelApiManager.get().closeUserChat(chatId, actionButton.getMessage().getId(), item.getRequestId()), this.createMessageSubscriber(item));
        }
    }

    private void reviewChat(SendingMessageItem item, @NonNull String review) {
        String chatId = item.getChatId();
        ActionButton actionButton = item.getActionButton();
        if (chatId != null && actionButton != null) {
            ChannelApiManager.call(ChannelApiManager.get().reviewUserChat(chatId, actionButton.getMessage().getId(), review, item.getRequestId()), this.createMessageSubscriber(item));
        }
    }

    private void submitSupportBotAction(SendingMessageItem item) {
        String chatId = item.getChatId();
        ActionButton actionButton = item.getActionButton();
        if (chatId != null && actionButton != null) {
            ChannelApiManager.call(ChannelApiManager.get().submitButtonAction(chatId, actionButton.getKey(), actionButton.getMessage().getId(), item.getRequestId()), this.createMessageSubscriber(item));
        }
    }

    private void onSendSuccess(Message message) {
        if (!this.released) {
            if (this.listeners != null) {
                for (OnMessageSendListener listener : this.listeners) {
                    listener.onSendSuccess(message);
                }
            }
            this.isMessageSending = false;
            this.sendWaitingMessage();
        }
    }

    private void onSendFail(Exception ex, SendingMessageItem item) {
        if (ex != null) {
            L.e(ex.getMessage());
        }
        if (!this.released) {
            item.setSendingState(SendingState.FAIL);
            this.failedItems.put(item.getPrimaryKey().longValue(), (Object)item);
            if (this.listeners != null) {
                for (OnMessageSendListener listener : this.listeners) {
                    listener.onSendFail(item);
                }
            }
            this.isMessageSending = false;
            this.sendWaitingMessage();
        }
    }

    private RestSubscriber<MessageWrapper> createMessageSubscriber(final SendingMessageItem item) {
        return new RestSubscriber<MessageWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                ChatManager.this.onSendFail(error, item);
            }

            @Override
            public void onSuccess(@NonNull MessageWrapper repo) {
                repo.update();
                ChatManager.this.onSendSuccess(repo.getMessage());
            }
        };
    }

    public void removeSendingFailedItem(Long createdAt) {
        if (createdAt != null) {
            this.failedItems.remove(createdAt.longValue());
        }
    }

    public List<MessageItem> getSendingItems(@Nullable String chatId) {
        ArrayList<MessageItem> items = new ArrayList<MessageItem>();
        for (SendingMessageItem item : this.sendingItems) {
            if (!CompareUtils.isSame(chatId, item.getChatId())) continue;
            items.add(item);
        }
        return items;
    }

    public List<MessageItem> getSendingFailedItems(@Nullable String chatId) {
        ArrayList<MessageItem> items = new ArrayList<MessageItem>();
        for (int i = 0; i < this.failedItems.size(); ++i) {
            SendingMessageItem item = (SendingMessageItem)this.failedItems.valueAt(i);
            if (!CompareUtils.isSame(chatId, item.getChatId())) continue;
            items.add(item);
        }
        return items;
    }

    public static void release() {
        if (chatManager != null) {
            ChatManager.chatManager.released = true;
            ChatManager.chatManager.sendingItems.clear();
            ChatManager.chatManager.failedItems.clear();
            chatManager = null;
        }
    }
}

