package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Step;
import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.selector.BotSelector;
import com.zoyi.channel.plugin.android.util.TimeUtils;

import java.util.List;

/**
 * Created by mika on 2018. 10. 26..
 */

public class SupportBotMessageItem extends InitMessageItem {

  @NonNull
  private SupportBotEntry supportBotEntry;

  public SupportBotMessageItem(@NonNull SupportBotEntry supportBotEntry) {
    super(
        new Message(
            supportBotEntry.getStep() != null ? supportBotEntry.getStep().getMessage() : null,
            Const.BOT, BotSelector.getDefaultBotId(),
            TimeUtils.getCurrentTime())
    );
    this.supportBotEntry = supportBotEntry;
  }

  @Nullable
  public List<ActionButton> getButtons() {
    return supportBotEntry.getButtons();
  }

  @Nullable
  public Step getStep() {
    return supportBotEntry.getStep();
  }

  @Nullable
  public String getSupportBotId() {
    if (supportBotEntry.getSupportBot() != null && supportBotEntry.getSupportBot().getId() != null) {
      return supportBotEntry.getSupportBot().getId();
    }
    return null;
  }

  @Override
  public String getSecondaryKey() {
    return "SupportBotMessageItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.SUPPORT_BOT;
  }
}
