/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.nineoldandroids.view;

import android.view.View;
import android.view.animation.Interpolator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.Animator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.animation.ValueAnimator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.view.ViewPropertyAnimator;
import com.zoyi.channel.plugin.android.view.external.nineoldandroids.view.animation.AnimatorProxy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

class ViewPropertyAnimatorPreHC
extends ViewPropertyAnimator {
    private final AnimatorProxy mProxy;
    private final WeakReference<View> mView;
    private long mDuration;
    private boolean mDurationSet = false;
    private long mStartDelay = 0L;
    private boolean mStartDelaySet = false;
    private Interpolator mInterpolator;
    private boolean mInterpolatorSet = false;
    private Animator.AnimatorListener mListener = null;
    private AnimatorEventListener mAnimatorEventListener = new AnimatorEventListener();
    ArrayList<NameValuesHolder> mPendingAnimations = new ArrayList();
    private static final int NONE = 0;
    private static final int TRANSLATION_X = 1;
    private static final int TRANSLATION_Y = 2;
    private static final int SCALE_X = 4;
    private static final int SCALE_Y = 8;
    private static final int ROTATION = 16;
    private static final int ROTATION_X = 32;
    private static final int ROTATION_Y = 64;
    private static final int X = 128;
    private static final int Y = 256;
    private static final int ALPHA = 512;
    private static final int TRANSFORM_MASK = 511;
    private Runnable mAnimationStarter = new Runnable(){

        @Override
        public void run() {
            ViewPropertyAnimatorPreHC.this.startAnimation();
        }
    };
    private HashMap<Animator, PropertyBundle> mAnimatorMap = new HashMap();

    ViewPropertyAnimatorPreHC(View view) {
        this.mView = new WeakReference<View>(view);
        this.mProxy = AnimatorProxy.wrap(view);
    }

    @Override
    public ViewPropertyAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDurationSet = true;
        this.mDuration = duration;
        return this;
    }

    @Override
    public long getDuration() {
        if (this.mDurationSet) {
            return this.mDuration;
        }
        return new ValueAnimator().getDuration();
    }

    @Override
    public long getStartDelay() {
        if (this.mStartDelaySet) {
            return this.mStartDelay;
        }
        return 0L;
    }

    @Override
    public ViewPropertyAnimator setStartDelay(long startDelay) {
        if (startDelay < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + startDelay);
        }
        this.mStartDelaySet = true;
        this.mStartDelay = startDelay;
        return this;
    }

    @Override
    public ViewPropertyAnimator setInterpolator(Interpolator interpolator) {
        this.mInterpolatorSet = true;
        this.mInterpolator = interpolator;
        return this;
    }

    @Override
    public ViewPropertyAnimator setListener(Animator.AnimatorListener listener) {
        this.mListener = listener;
        return this;
    }

    @Override
    public void start() {
        this.startAnimation();
    }

    @Override
    public void cancel() {
        if (this.mAnimatorMap.size() > 0) {
            HashMap mAnimatorMapCopy = (HashMap)this.mAnimatorMap.clone();
            Set animatorSet = mAnimatorMapCopy.keySet();
            for (Animator runningAnim : animatorSet) {
                runningAnim.cancel();
            }
        }
        this.mPendingAnimations.clear();
        View v = (View)this.mView.get();
        if (v != null) {
            v.removeCallbacks(this.mAnimationStarter);
        }
    }

    @Override
    public ViewPropertyAnimator x(float value) {
        this.animateProperty(128, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator xBy(float value) {
        this.animatePropertyBy(128, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator y(float value) {
        this.animateProperty(256, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator yBy(float value) {
        this.animatePropertyBy(256, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator rotation(float value) {
        this.animateProperty(16, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator rotationBy(float value) {
        this.animatePropertyBy(16, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator rotationX(float value) {
        this.animateProperty(32, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator rotationXBy(float value) {
        this.animatePropertyBy(32, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator rotationY(float value) {
        this.animateProperty(64, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator rotationYBy(float value) {
        this.animatePropertyBy(64, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator translationX(float value) {
        this.animateProperty(1, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator translationXBy(float value) {
        this.animatePropertyBy(1, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator translationY(float value) {
        this.animateProperty(2, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator translationYBy(float value) {
        this.animatePropertyBy(2, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator scaleX(float value) {
        this.animateProperty(4, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator scaleXBy(float value) {
        this.animatePropertyBy(4, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator scaleY(float value) {
        this.animateProperty(8, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator scaleYBy(float value) {
        this.animatePropertyBy(8, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator alpha(float value) {
        this.animateProperty(512, value);
        return this;
    }

    @Override
    public ViewPropertyAnimator alphaBy(float value) {
        this.animatePropertyBy(512, value);
        return this;
    }

    private void startAnimation() {
        ValueAnimator animator = ValueAnimator.ofFloat(1.0f);
        ArrayList nameValueList = (ArrayList)this.mPendingAnimations.clone();
        this.mPendingAnimations.clear();
        int propertyMask = 0;
        int propertyCount = nameValueList.size();
        for (int i = 0; i < propertyCount; ++i) {
            NameValuesHolder nameValuesHolder = (NameValuesHolder)nameValueList.get(i);
            propertyMask |= nameValuesHolder.mNameConstant;
        }
        this.mAnimatorMap.put(animator, new PropertyBundle(propertyMask, nameValueList));
        animator.addUpdateListener(this.mAnimatorEventListener);
        animator.addListener(this.mAnimatorEventListener);
        if (this.mStartDelaySet) {
            animator.setStartDelay(this.mStartDelay);
        }
        if (this.mDurationSet) {
            animator.setDuration(this.mDuration);
        }
        if (this.mInterpolatorSet) {
            animator.setInterpolator(this.mInterpolator);
        }
        animator.start();
    }

    private void animateProperty(int constantName, float toValue) {
        float fromValue = this.getValue(constantName);
        float deltaValue = toValue - fromValue;
        this.animatePropertyBy(constantName, fromValue, deltaValue);
    }

    private void animatePropertyBy(int constantName, float byValue) {
        float fromValue = this.getValue(constantName);
        this.animatePropertyBy(constantName, fromValue, byValue);
    }

    private void animatePropertyBy(int constantName, float startValue, float byValue) {
        if (this.mAnimatorMap.size() > 0) {
            Animator animatorToCancel = null;
            Set<Animator> animatorSet = this.mAnimatorMap.keySet();
            for (Animator runningAnim : animatorSet) {
                PropertyBundle bundle = this.mAnimatorMap.get(runningAnim);
                if (!bundle.cancel(constantName) || bundle.mPropertyMask != 0) continue;
                animatorToCancel = runningAnim;
                break;
            }
            if (animatorToCancel != null) {
                animatorToCancel.cancel();
            }
        }
        NameValuesHolder nameValuePair = new NameValuesHolder(constantName, startValue, byValue);
        this.mPendingAnimations.add(nameValuePair);
        View v = (View)this.mView.get();
        if (v != null) {
            v.removeCallbacks(this.mAnimationStarter);
            v.post(this.mAnimationStarter);
        }
    }

    private void setValue(int propertyConstant, float value) {
        switch (propertyConstant) {
            case 1: {
                this.mProxy.setTranslationX(value);
                break;
            }
            case 2: {
                this.mProxy.setTranslationY(value);
                break;
            }
            case 16: {
                this.mProxy.setRotation(value);
                break;
            }
            case 32: {
                this.mProxy.setRotationX(value);
                break;
            }
            case 64: {
                this.mProxy.setRotationY(value);
                break;
            }
            case 4: {
                this.mProxy.setScaleX(value);
                break;
            }
            case 8: {
                this.mProxy.setScaleY(value);
                break;
            }
            case 128: {
                this.mProxy.setX(value);
                break;
            }
            case 256: {
                this.mProxy.setY(value);
                break;
            }
            case 512: {
                this.mProxy.setAlpha(value);
            }
        }
    }

    private float getValue(int propertyConstant) {
        switch (propertyConstant) {
            case 1: {
                return this.mProxy.getTranslationX();
            }
            case 2: {
                return this.mProxy.getTranslationY();
            }
            case 16: {
                return this.mProxy.getRotation();
            }
            case 32: {
                return this.mProxy.getRotationX();
            }
            case 64: {
                return this.mProxy.getRotationY();
            }
            case 4: {
                return this.mProxy.getScaleX();
            }
            case 8: {
                return this.mProxy.getScaleY();
            }
            case 128: {
                return this.mProxy.getX();
            }
            case 256: {
                return this.mProxy.getY();
            }
            case 512: {
                return this.mProxy.getAlpha();
            }
        }
        return 0.0f;
    }

    private class AnimatorEventListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private AnimatorEventListener() {
        }

        @Override
        public void onAnimationStart(Animator animation) {
            if (ViewPropertyAnimatorPreHC.this.mListener != null) {
                ViewPropertyAnimatorPreHC.this.mListener.onAnimationStart(animation);
            }
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            if (ViewPropertyAnimatorPreHC.this.mListener != null) {
                ViewPropertyAnimatorPreHC.this.mListener.onAnimationCancel(animation);
            }
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
            if (ViewPropertyAnimatorPreHC.this.mListener != null) {
                ViewPropertyAnimatorPreHC.this.mListener.onAnimationRepeat(animation);
            }
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            if (ViewPropertyAnimatorPreHC.this.mListener != null) {
                ViewPropertyAnimatorPreHC.this.mListener.onAnimationEnd(animation);
            }
            ViewPropertyAnimatorPreHC.this.mAnimatorMap.remove(animation);
            if (ViewPropertyAnimatorPreHC.this.mAnimatorMap.isEmpty()) {
                ViewPropertyAnimatorPreHC.this.mListener = null;
            }
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            View v;
            ArrayList<NameValuesHolder> valueList;
            View v2;
            float fraction = animation.getAnimatedFraction();
            PropertyBundle propertyBundle = (PropertyBundle)ViewPropertyAnimatorPreHC.this.mAnimatorMap.get(animation);
            int propertyMask = propertyBundle.mPropertyMask;
            if ((propertyMask & 0x1FF) != 0 && (v2 = (View)ViewPropertyAnimatorPreHC.this.mView.get()) != null) {
                v2.invalidate();
            }
            if ((valueList = propertyBundle.mNameValuesHolder) != null) {
                int count = valueList.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder values = valueList.get(i);
                    float value = values.mFromValue + fraction * values.mDeltaValue;
                    ViewPropertyAnimatorPreHC.this.setValue(values.mNameConstant, value);
                }
            }
            if ((v = (View)ViewPropertyAnimatorPreHC.this.mView.get()) != null) {
                v.invalidate();
            }
        }
    }

    private static class NameValuesHolder {
        int mNameConstant;
        float mFromValue;
        float mDeltaValue;

        NameValuesHolder(int nameConstant, float fromValue, float deltaValue) {
            this.mNameConstant = nameConstant;
            this.mFromValue = fromValue;
            this.mDeltaValue = deltaValue;
        }
    }

    private static class PropertyBundle {
        int mPropertyMask;
        ArrayList<NameValuesHolder> mNameValuesHolder;

        PropertyBundle(int propertyMask, ArrayList<NameValuesHolder> nameValuesHolder) {
            this.mPropertyMask = propertyMask;
            this.mNameValuesHolder = nameValuesHolder;
        }

        boolean cancel(int propertyConstant) {
            if ((this.mPropertyMask & propertyConstant) != 0 && this.mNameValuesHolder != null) {
                int count = this.mNameValuesHolder.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder nameValuesHolder = this.mNameValuesHolder.get(i);
                    if (nameValuesHolder.mNameConstant != propertyConstant) continue;
                    this.mNameValuesHolder.remove(i);
                    this.mPropertyMask &= ~propertyConstant;
                    return true;
                }
            }
            return false;
        }
    }
}

