/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.util.SortedList;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.base.SortedListCallback;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapterContract2;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileBotUpdateListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.DateItem;
import com.zoyi.channel.plugin.android.activity.chat.model.InitMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.LogMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.NewMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.PushBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.TypingItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ChatMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.DateDividerHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.LogMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.NewMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ProfileBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.PushBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SendingMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.SupportBotMessageHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.TypingHolder;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.WelcomeMessageHolder;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.store.ImageFileStore;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChatAdapter2
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ChatAdapterContract2.Model,
ChatAdapterContract2.View {
    private SortedList<MessageItem> items = new SortedList(MessageItem.class, new SortedListCallback(this, false));
    @Nullable
    private OnProfileBotUpdateListener onProfileBotUpdateListener;
    @Nullable
    private OnMessageContentClickListener onMessageContentClickListener;
    @NonNull
    private TypingItem typingItem = new TypingItem();
    @Nullable
    private InitMessageItem initMessageItem;
    @Nullable
    private DateItem initMessageDateItem;
    @Nullable
    private NewMessageItem newMessageItem;
    private boolean editTextFocused = false;

    ChatAdapter2() {
        this.items.add((Object)this.typingItem);
    }

    public void setOnProfileBotUpdateListener(@Nullable OnProfileBotUpdateListener onProfileBotUpdateListener) {
        this.onProfileBotUpdateListener = onProfileBotUpdateListener;
    }

    public void setOnMessageContentClickListener(@Nullable OnMessageContentClickListener onMessageContentClickListener) {
        this.onMessageContentClickListener = onMessageContentClickListener;
    }

    @Override
    public void setMessages(List<Message> messages) {
        this.resetSpecialMessageItems();
        this.items.replaceAll(this.getItemsFromMessages(messages));
        this.items.add((Object)this.typingItem);
    }

    @Override
    public int addMessage(Message message) {
        return this.addMessages(Collections.singletonList(message));
    }

    @Override
    public int addMessages(List<Message> messages) {
        int prevSize = this.items.size();
        List<MessageItem> newItems = this.getItemsFromMessages(messages);
        this.items.beginBatchedUpdates();
        for (MessageItem item : newItems) {
            this.items.add((Object)item);
        }
        for (Message message : messages) {
            SendingMessageItem item;
            if (message == null || !CompareUtils.exists((Comparable)((Object)message.getPersonType()), (Comparable[])new String[]{"User", "Veil"}) || (item = SendingMessageItem.createDummy(message.getRequestId())) == null) continue;
            this.items.remove((Object)item);
        }
        this.items.endBatchedUpdates();
        return this.items.size() - prevSize;
    }

    @NonNull
    private List<MessageItem> getItemsFromMessages(List<Message> messages) {
        ArrayList<MessageItem> newItems = new ArrayList<MessageItem>();
        for (Message message : messages) {
            if (message == null) continue;
            if (message.getLog() != null) {
                newItems.add(new LogMessageItem(message));
                continue;
            }
            if (message.getFile() != null && message.getFile().isImageFile()) {
                Store.getInstance(ImageFileStore.class).add(message.getFile());
            }
            newItems.add(new ChatMessageItem(message));
            newItems.add(new DateItem(message.getCreatedAt()));
            if (message.getProfileBot() == null) continue;
            newItems.add(new ProfileBotMessageItem(message));
        }
        return newItems;
    }

    @Override
    public void addMessageItem(MessageItem item) {
        this.items.add((Object)item);
    }

    @Override
    public void addMessageItems(List<? extends MessageItem> items) {
        this.items.addAll(items);
    }

    @Override
    public void removeMessageItem(MessageItem item) {
        if (item != null) {
            this.items.remove((Object)item);
        }
    }

    @Override
    public void upsertTyping(Typing typing) {
        this.typingItem.addOrUpdateTyping(typing);
        this.addMessageItem(this.typingItem);
    }

    @Override
    public void removeTyping(Typing typing) {
        this.typingItem.removeTyping(typing);
        this.addMessageItem(this.typingItem);
    }

    @Override
    public void upsertInitMessage(InitMessageItem item) {
        this.items.beginBatchedUpdates();
        if (this.initMessageItem != null) {
            this.items.remove((Object)this.initMessageItem);
            this.initMessageItem = null;
        }
        if (this.initMessageDateItem != null) {
            this.items.remove((Object)this.initMessageDateItem);
            this.initMessageDateItem = null;
        }
        if (item != null) {
            this.initMessageItem = item;
            this.items.add((Object)item);
            this.initMessageDateItem = new DateItem(this.initMessageItem.getCreatedAt());
            this.items.add((Object)this.initMessageDateItem);
        }
        this.items.endBatchedUpdates();
    }

    @Override
    public void replaceInitMessage(Message message) {
        this.items.beginBatchedUpdates();
        if (this.initMessageItem != null) {
            this.items.remove((Object)this.initMessageItem);
            this.initMessageItem = null;
        }
        if (this.initMessageDateItem != null) {
            this.items.remove((Object)this.initMessageDateItem);
            this.initMessageDateItem = null;
        }
        for (MessageItem item : this.getItemsFromMessages(Collections.singletonList(message))) {
            this.items.add((Object)item);
        }
        this.items.endBatchedUpdates();
    }

    @Override
    public void upsertNewMessageItem(long createdAt) {
        if (this.newMessageItem != null) {
            this.items.remove((Object)this.newMessageItem);
        }
        this.newMessageItem = new NewMessageItem(createdAt);
        this.items.addAll((Object[])new MessageItem[]{this.newMessageItem});
    }

    @Nullable
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        MessageType type = MessageType.fromId(viewType);
        switch (type) {
            case NEW_MESSAGE_DIVIDER: {
                return NewMessageHolder.newInstance(parent);
            }
            case TYPING: {
                return TypingHolder.newInstance(parent);
            }
            case DATE: {
                return DateDividerHolder.newInstance(parent);
            }
            case LOG: {
                return LogMessageHolder.newInstance(parent);
            }
            case SENDING: {
                return SendingMessageHolder.newInstance(parent, type, this.onMessageContentClickListener);
            }
            case HOST: 
            case GUEST: {
                return ChatMessageHolder.newInstance(parent, type, this.onMessageContentClickListener);
            }
            case PROFILE_BOT: {
                return ProfileBotMessageHolder.newInstance(parent, this.onProfileBotUpdateListener);
            }
            case WELCOME: {
                return WelcomeMessageHolder.newInstance(parent);
            }
            case SUPPORT_BOT: {
                return SupportBotMessageHolder.newInstance(parent, this.onMessageContentClickListener);
            }
            case PUSH_BOT: {
                return PushBotMessageHolder.newInstance(parent, this.onMessageContentClickListener);
            }
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        MessageItem item = (MessageItem)this.items.get(position);
        switch (item.getType()) {
            case TYPING: {
                TypingHolder typingHolder = (TypingHolder)holder;
                typingHolder.bind((TypingItem)item);
                break;
            }
            case DATE: {
                DateDividerHolder dateDividerHolder = (DateDividerHolder)holder;
                dateDividerHolder.bind((DateItem)item);
                break;
            }
            case LOG: {
                LogMessageHolder logMessageHolder = (LogMessageHolder)holder;
                logMessageHolder.bind((LogMessageItem)item);
                break;
            }
            case SENDING: {
                SendingMessageItem sendingMessageItem = (SendingMessageItem)item;
                SendingMessageHolder sendingHolder = (SendingMessageHolder)holder;
                sendingHolder.bind((SendingMessageItem)item, sendingMessageItem.isConnected(this.getItem(position - 1)));
                break;
            }
            case HOST: 
            case GUEST: {
                ChatMessageItem chatMessageItem = (ChatMessageItem)item;
                ChatMessageHolder chatMessageHolder = (ChatMessageHolder)holder;
                chatMessageHolder.bind(chatMessageItem, chatMessageItem.isConnected(this.getItem(position - 1)), this.isLastPosition(position));
                break;
            }
            case PROFILE_BOT: {
                ProfileBotMessageItem profileItem = (ProfileBotMessageItem)item;
                ProfileBotMessageHolder profileBotMessageHolder = (ProfileBotMessageHolder)holder;
                profileBotMessageHolder.bind(profileItem, this.isEditTextFocused());
                break;
            }
            case WELCOME: {
                WelcomeMessageItem welcomeMessageItem = (WelcomeMessageItem)item;
                WelcomeMessageHolder welcomeMessageHolder = (WelcomeMessageHolder)holder;
                welcomeMessageHolder.bind(welcomeMessageItem);
                break;
            }
            case SUPPORT_BOT: {
                SupportBotMessageItem supportBotMessageItem = (SupportBotMessageItem)item;
                SupportBotMessageHolder supportBotMessageHolder = (SupportBotMessageHolder)holder;
                supportBotMessageHolder.bind(supportBotMessageItem, this.isLastPosition(position));
                break;
            }
            case PUSH_BOT: {
                PushBotMessageItem pushBotMessageItem = (PushBotMessageItem)item;
                PushBotMessageHolder pushBotMessageHolder = (PushBotMessageHolder)holder;
                pushBotMessageHolder.bind(pushBotMessageItem);
            }
        }
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getItemViewType(int position) {
        return ((MessageItem)this.items.get(position)).getType().toInt();
    }

    private void resetSpecialMessageItems() {
        this.initMessageItem = null;
        this.initMessageDateItem = null;
        this.newMessageItem = null;
    }

    @Nullable
    private MessageItem getItem(int position) {
        if (position >= 0 && position < this.items.size()) {
            return (MessageItem)this.items.get(position);
        }
        return null;
    }

    private boolean isLastPosition(int position) {
        return position == this.getItemCount() - 2;
    }

    private boolean isEditTextFocused() {
        return this.editTextFocused;
    }

    void setEditTextFocused(boolean editTextFocused) {
        this.editTextFocused = editTextFocused;
    }
}

