/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;

public class BottomFloatingActionLayout
extends LinearLayout {
    private Context context;
    private View root;
    @Nullable
    private RecyclerView recyclerView;
    @Nullable
    private Channel channel;
    private boolean firstHideAnimation = false;

    public BottomFloatingActionLayout(Context context) {
        super(context);
        this.init(context);
    }

    public BottomFloatingActionLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BottomFloatingActionLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    public void init(Context context) {
        this.root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_chat_bottom_frame, (ViewGroup)this);
        this.context = context;
        this.channel = ChannelSelector.getCurrentChannel();
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        this.setRecyclerViewBottomPadding(this.channel, null);
    }

    public void bindUserChatState(String userChatState) {
        this.setRecyclerViewBottomPadding(this.channel, userChatState);
    }

    private void setRecyclerViewBottomPadding(@Nullable Channel channel, @Nullable String userChatState) {
        if (this.recyclerView != null) {
            int bottomPadding = CompareUtils.isSame(userChatState, "closed") ? (channel != null && channel.isTrial() ? (int)Utils.dpToPx(this.context, 70.0f) : (int)Utils.dpToPx(this.context, 40.0f)) : (channel != null && channel.isTrial() ? (int)Utils.dpToPx(this.context, 30.0f) : 0);
            this.recyclerView.setPadding(0, 0, 0, bottomPadding);
        }
    }

    public void show() {
        this.animateButton(false);
    }

    public void hide() {
        if (!this.firstHideAnimation) {
            this.animateButton(true);
        }
    }

    private void animateButton(boolean isHiding) {
        this.firstHideAnimation = isHiding;
        this.root.animate().translationY(isHiding ? 300.0f : 0.0f).start();
    }
}

