package com.zoyi.channel.plugin.android.model.wrapper;

import com.zoyi.channel.plugin.android.store.*;

public class ChatPreloadWrapper extends BaseRepo {

  private ManagersWrapper managersWrapper;
  private PluginWrapper pluginWrapper;
  private SupportBotsWrapper supportBotsWrapper;
  private SupportBotEntry supportBotEntry;

  public ChatPreloadWrapper(ManagersWrapper managersWrapper, PluginWrapper pluginWrapper, SupportBotsWrapper supportBotsWrapper) {
    this.managersWrapper = managersWrapper;
    this.pluginWrapper = pluginWrapper;
    this.supportBotsWrapper = supportBotsWrapper;
  }

  public SupportBotsWrapper getSupportBotsWrapper() {
    return supportBotsWrapper;
  }

  public ChatPreloadWrapper updateSupportBotEntry(SupportBotEntry supportBotEntry) {
    this.supportBotEntry = supportBotEntry;
    return this;
  }

  public SupportBotEntry getSupportBotEntry() {
    return supportBotEntry;
  }

  @Override
  public void update() {
    if (managersWrapper != null) {
      managersWrapper.update();
      managersWrapper.setFollowingManagers();
    }
    if (pluginWrapper != null) {
      Store.getInstance(PluginStore.class).update(pluginWrapper.getPlugin());
      Store.getInstance(ChannelStore.class).update(pluginWrapper.getChannel());
      Store.getInstance(UserStore.class).update(pluginWrapper.getUser());
      Store.getInstance(VeilStore.class).update(pluginWrapper.getVeil());
      Store.getInstance(BotStore.class).add(pluginWrapper.getBot());
      Store.getInstance(BotStore.class).setDefaultBot(pluginWrapper.getBot());
    }
  }
}
