/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.type.ChatNavigationState;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.ChannelSelector;
import com.zoyi.channel.plugin.android.selector.ColorSelector;
import com.zoyi.channel.plugin.android.selector.ManagerSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.CHTextView;
import java.util.List;

public class ChatNavigationView
extends LinearLayout {
    private View layoutRoot;
    private View layoutPending;
    private CHTextView textPendingTitle;
    private CHTextView textPendingDescription;
    private View layoutPendingAvatars;
    private AvatarLayout avatarPendingFirst;
    private AvatarLayout avatarPendingSecond;
    private AvatarLayout avatarPendingThird;
    private CHTextView textPendingWorkingTime;
    private View layoutFollowing;
    private View layoutFollowingAvatarFrame;
    private AvatarLayout avatarFollowing;
    private View viewFollowingManagerOnlineBadge;
    private View viewFollowingManagerOnlineBadgeFrame;
    private CHTextView textFollowingManagerDescription;
    private ChatNavigationState state = ChatNavigationState.IDLE;

    public ChatNavigationView(Context context) {
        super(context);
        this.init(context);
    }

    public ChatNavigationView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChatNavigationView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.layoutRoot = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_chat_navigation, (ViewGroup)this);
        this.layoutPending = this.layoutRoot.findViewById(R.id.layout_chat_navigation_pending);
        this.textPendingTitle = (CHTextView)this.layoutRoot.findViewById(R.id.text_chat_navigation_pending_title);
        this.textPendingDescription = (CHTextView)this.layoutRoot.findViewById(R.id.text_chat_navigation_pending_description);
        this.layoutPendingAvatars = this.layoutRoot.findViewById(R.id.layout_chat_navigation_pending_avatars);
        this.avatarPendingFirst = (AvatarLayout)this.layoutRoot.findViewById(R.id.avatar_chat_navigation_pending_first);
        this.avatarPendingSecond = (AvatarLayout)this.layoutRoot.findViewById(R.id.avatar_chat_navigation_pending_second);
        this.avatarPendingThird = (AvatarLayout)this.layoutRoot.findViewById(R.id.avatar_chat_navigation_pending_third);
        this.textPendingWorkingTime = (CHTextView)this.layoutRoot.findViewById(R.id.text_chat_navigation_working_time);
        this.layoutFollowing = this.layoutRoot.findViewById(R.id.layout_chat_navigation_following);
        this.layoutFollowingAvatarFrame = this.layoutRoot.findViewById(R.id.view_chat_navigation_following_manager_frame);
        this.avatarFollowing = (AvatarLayout)this.layoutRoot.findViewById(R.id.avatar_chat_navigation_following);
        this.viewFollowingManagerOnlineBadge = this.layoutRoot.findViewById(R.id.badge_chat_navigation_following_manager_online);
        this.viewFollowingManagerOnlineBadgeFrame = this.layoutRoot.findViewById(R.id.view_chat_navigation_following_manager_online_frame);
        this.textFollowingManagerDescription = (CHTextView)this.layoutRoot.findViewById(R.id.text_chat_navigation_following_manager_description);
        this.layoutRoot.setBackgroundColor(ColorSelector.getBackgroundColor());
        this.avatarPendingFirst.setBorderColor(ColorSelector.getBackgroundColor());
        this.avatarPendingSecond.setBorderColor(ColorSelector.getBackgroundColor());
        this.avatarPendingThird.setBorderColor(ColorSelector.getBackgroundColor());
        this.avatarFollowing.setBorderColor(ColorSelector.getBackgroundColor());
        this.viewFollowingManagerOnlineBadgeFrame.setBackgroundColor(ColorSelector.getBackgroundColor());
        this.textPendingTitle.setTextColor(ColorSelector.getTextColor());
        this.textPendingDescription.setTextColor(ColorSelector.getTextColor());
        this.textPendingWorkingTime.setTextColor(ColorSelector.getTextColor());
        this.textFollowingManagerDescription.setTextColor(ColorSelector.getTextColor());
        this.layoutRoot.setVisibility(8);
        this.layoutPending.setVisibility(8);
        this.layoutFollowing.setVisibility(8);
        this.bindFollowingManagers(ManagerSelector.getFollowingManagers());
        this.bindChannel(ChannelSelector.getCurrentChannel());
    }

    public void bindFollowingManagers(@Nullable List<Manager> followingManagers) {
        if (followingManagers != null) {
            this.layoutPendingAvatars.setVisibility(0);
            this.avatarPendingFirst.set(followingManagers.size() > 0 ? (ProfileEntity)followingManagers.get(0) : null);
            this.avatarPendingSecond.set(followingManagers.size() > 1 ? (ProfileEntity)followingManagers.get(1) : null);
            this.avatarPendingThird.set(followingManagers.size() > 2 ? (ProfileEntity)followingManagers.get(2) : null);
        }
    }

    public void bindChannel(@Nullable Channel channel) {
        if (channel != null) {
            this.layoutRoot.setVisibility(0);
        }
        this.textPendingTitle.setTextByKey(ChatResponseManager.getResponseKey(channel));
        this.textPendingTitle.setCompoundDrawablesWithIntrinsicBounds(0, 0, ChatResponseManager.getResponseSymbol(channel), 0);
        this.textPendingDescription.setTextByKey(ChatResponseManager.getResponseDescriptionKey(channel));
        int maxAvatarCount = ChatResponseManager.showOnlyOneManager(channel) ? 1 : 3;
        Views.setVisibility((View)this.avatarPendingFirst, this.avatarPendingFirst.isValid());
        Views.setVisibility((View)this.avatarPendingSecond, this.avatarPendingSecond.isValid() && maxAvatarCount >= 2);
        Views.setVisibility((View)this.avatarPendingThird, this.avatarPendingThird.isValid() && maxAvatarCount >= 3);
        boolean workingTimeNotExists = channel == null || channel.isWorking() || "never".equals(channel.getWorkingType()) || channel.getWorkingTime(this.getContext()) == null;
        Views.setVisibility((View)this.textPendingWorkingTime, !workingTimeNotExists);
    }

    public boolean bindUserChat(@Nullable UserChat userChat) {
        ChatNavigationState oldState = this.state;
        Person followingPerson = ProfileSelector.getPerson(userChat != null ? userChat.getHostType() : null, userChat != null ? userChat.getHostId() : null);
        this.state = followingPerson != null ? ChatNavigationState.FOLLOWING : ChatResponseManager.getNavigationState(ChannelSelector.getCurrentChannel());
        Views.setVisibility(this.layoutPending, this.state != ChatNavigationState.FOLLOWING);
        Views.setVisibility(this.layoutFollowing, this.state == ChatNavigationState.FOLLOWING);
        if (this.state == ChatNavigationState.FOLLOWING) {
            this.avatarFollowing.set(followingPerson);
            if (followingPerson != null && followingPerson instanceof Manager) {
                Manager followingManager = (Manager)followingPerson;
                Views.setVisibility(this.viewFollowingManagerOnlineBadge, followingManager.getOnline());
                Views.setVisibility((View)this.textFollowingManagerDescription, false);
            } else {
                this.viewFollowingManagerOnlineBadge.setVisibility(8);
                this.textFollowingManagerDescription.setVisibility(8);
            }
            if (this.state != oldState) {
                this.animateScaleUpView(this.layoutFollowingAvatarFrame, 0);
            }
        } else if (this.state != oldState) {
            this.animateScaleUpView((View)this.avatarPendingFirst, 0);
            this.animateScaleUpView((View)this.avatarPendingSecond, 1);
            this.animateScaleUpView((View)this.avatarPendingThird, 2);
        }
        return this.state == ChatNavigationState.FOLLOWING;
    }

    private void animateScaleUpView(final View view, int index) {
        view.setScaleX(0.3f);
        view.setScaleY(0.3f);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                view.animate().scaleX(1.0f).scaleY(1.0f).start();
            }
        }, (long)(index + 50 + 200));
    }
}

