package com.zoyi.channel.plugin.android.activity.base;

import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.util.SortedListAdapterCallback;

import com.zoyi.channel.plugin.android.util.CompareUtils;

/**
 * Created by mika on 2016. 7. 5..
 */
public class SortedListCallback<E extends SortableItem> extends SortedListAdapterCallback<E> {

  private RecyclerView.Adapter adapter;
  private boolean desc;

  public SortedListCallback(RecyclerView.Adapter adapter, boolean desc) {
    super(adapter);
    this.desc = desc;
    this.adapter = adapter;
  }

  @Override
  public int compare(SortableItem o1, SortableItem o2) {
    int comp = CompareUtils.compare(o2.getPrimaryKey(), o1.getPrimaryKey());
    if (comp == 0) {
      return CompareUtils.compare(o2.getSecondaryKey(), o1.getSecondaryKey()) * (desc ? 1 : -1);
    }
    return comp * (desc ? 1 : -1);
  }

  @Override
  public boolean areContentsTheSame(SortableItem oldItem, SortableItem newItem) {
    return false;
  }

  @Override
  public void onInserted(int position, int count) {
    try {
      adapter.notifyItemRangeInserted(position, count);
      adapter.notifyItemChanged(position - 1);
      adapter.notifyItemChanged(position + count);
    } catch (Exception ignored) { }
  }

  @Override
  public void onRemoved(int position, int count) {
    try {
      adapter.notifyItemRangeRemoved(position, count);
      adapter.notifyItemChanged(Math.max(position - 1, 0), 2);
    } catch (Exception ignored) {
    }
  }

  @Override
  public boolean areItemsTheSame(SortableItem item1, SortableItem item2) {
    return CompareUtils.compare(item1.getPrimaryKey(), item2.getPrimaryKey()) == 0 &&
        CompareUtils.compare(item1.getSecondaryKey(), item2.getSecondaryKey()) == 0;
  }
}
