/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class MessageButtonView
extends FrameLayout {
    private View root;
    private TextView textButtonTitle;

    public MessageButtonView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public MessageButtonView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MessageButtonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.root = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_message_button, (ViewGroup)this, true);
        this.root.setBackgroundColor(ResUtils.getColor(R.color.ch_white));
        this.root.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        MessageButtonView.this.root.setBackgroundColor(ResUtils.getColor(R.color.ch_snow));
                        break;
                    }
                    case 1: 
                    case 3: {
                        MessageButtonView.this.root.setBackgroundColor(ResUtils.getColor(R.color.ch_white));
                    }
                }
                return false;
            }
        });
        this.textButtonTitle = (TextView)this.root.findViewById(R.id.ch_text_message_button_title);
    }

    public void setButtonTitle(String title) {
        this.textButtonTitle.setText((CharSequence)title);
    }

    public void setButtonClickListener(View.OnClickListener onClickListener) {
        this.root.setOnClickListener(onClickListener);
    }
}

