package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.store.ManagerStore;
import com.zoyi.channel.plugin.android.store.Store;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * Created by mika on 2018. 6. 18..
 */

public class ManagerSelector {

  @NonNull
  public static List<Manager> getFollowingManagers() {
    List<Manager> managers = new ArrayList<>();
    Set<String> followingManagerIds = Store.getInstance(ManagerStore.class).getFollowingManagerIds();

    if (followingManagerIds != null) {
      for (String managerId : followingManagerIds) {
        Manager manager = Store.getInstance(ManagerStore.class).get(managerId);

        if (manager != null) {
          managers.add(manager);
        }
      }
    }

    return managers;
  }
}
