/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.RetrofitInterceptor;
import com.zoyi.channel.plugin.android.network.ServerTimeInterceptor;
import com.zoyi.channel.plugin.android.network.TokenInterceptor;
import com.zoyi.channel.plugin.android.network.UserAgentInterceptor;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.PersistentCookieJar;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.cache.SetCookieCache;
import com.zoyi.channel.plugin.android.util.persistentcookiejar.persistence.SharedPrefsCookiePersistor;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.okhttp3.CookieJar;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.OkHttpClient;
import com.zoyi.okhttp3.logging.HttpLoggingInterceptor;
import com.zoyi.retrofit2.CallAdapter;
import com.zoyi.retrofit2.Converter;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import com.zoyi.retrofit2.converter.gson.GsonConverterFactory;

public class ServiceFactory {
    static String REST_END_POINT = "https://api.channel.io/";

    public static ChannelApi create() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor().setLevel(ChannelIO.isDebugMode() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().addInterceptor((Interceptor)new RetrofitInterceptor()).addInterceptor((Interceptor)new UserAgentInterceptor()).addInterceptor((Interceptor)new TokenInterceptor()).addInterceptor((Interceptor)new ServerTimeInterceptor()).addInterceptor((Interceptor)loggingInterceptor);
        if (ChannelIO.getAppContext() != null) {
            PersistentCookieJar cookieJar = new PersistentCookieJar(new SetCookieCache(), new SharedPrefsCookiePersistor(ChannelIO.getAppContext()));
            clientBuilder.cookieJar((CookieJar)cookieJar);
        }
        OkHttpClient client = clientBuilder.build();
        return (ChannelApi)new Retrofit.Builder().baseUrl(REST_END_POINT).client(client).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)ParseUtils.getCustomGson())).build().create(ChannelApi.class);
    }
}

