/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.deserializer;

import android.text.SpannableStringBuilder;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.JsonDeserializationContext;
import com.zoyi.com.google.gson.JsonDeserializer;
import com.zoyi.com.google.gson.JsonElement;
import com.zoyi.com.google.gson.JsonParseException;
import java.lang.reflect.Type;

public class MessageDeserializer
implements JsonDeserializer {
    private Gson gson = new Gson();

    public Object deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Message message = (Message)this.gson.fromJson(json, type);
        if (message != null) {
            if (message.getMessage() != null) {
                SpannableStringBuilder formattedMessage = ParseUtils.parseMessage(message.getMessage());
                message.setFormattedSpanMessage(formattedMessage);
                if (formattedMessage != null) {
                    String formattedStringMessage = formattedMessage.toString();
                    message.setFormattedStringMessage(formattedStringMessage);
                }
            }
            if (message.getForm() != null && ListUtils.hasItems(message.getForm().getInputs())) {
                for (ActionInput actionInput : message.getForm().getInputs()) {
                    actionInput.setMessage(message);
                }
            }
        }
        return message;
    }
}

