/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ContentMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;

public class ChatMessageHolder
extends ContentMessageHolder {
    public static ChatMessageHolder newInstance(ViewGroup parent, MessageType messageType, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        return new ChatMessageHolder(ChatMessageHolder.getItemView(parent, messageType), messageType, onMessageContentClickListener);
    }

    private ChatMessageHolder(View itemView, MessageType messageType, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        super(itemView, messageType, onMessageContentClickListener);
    }

    public void bind(ChatMessageItem chatMessageItem, boolean isConnectedMessage, boolean isLastMessage) {
        Message message = chatMessageItem.getMessage();
        super.bind(message, chatMessageItem.getType(), isConnectedMessage);
        if (message != null) {
            if (message.getFile() != null) {
                this.bindFile(message.getFile());
            }
            if (message.getWebPage() != null) {
                this.setWebPage(message.getWebPage());
            }
            if (message.getForm() != null && isLastMessage) {
                this.setFormMessage(message);
            }
            if (message.shouldTranslate() && chatMessageItem.getType() == MessageType.HOST) {
                this.setTranslationButton(message, isConnectedMessage);
            }
            if (message.hasButtons()) {
                this.setMessageButtons(message.getButtons());
            }
        }
    }

    protected void bindFile(File file) {
        if (file.isImage()) {
            if (file.getImageRedirectUrl() != null) {
                this.setLinkableImage(file.getPreviewThumb());
            } else {
                this.setImage(file.getPreviewThumb());
            }
        } else {
            this.setFileDescription(file);
        }
    }

    @Override
    protected void onLinkableImageClick() {
        if (this.onMessageContentClickListener != null && this.message != null && this.message.getFile() != null) {
            this.onMessageContentClickListener.onRedirectContentsClick(this.message.getFile().getImageRedirectUrl());
        }
    }
}

