/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnErrorThrowable;
import com.zoyi.rx.plugins.RxJavaHooks;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorCast<T, R>
implements Observable.Operator<R, T> {
    final Class<R> castClass;

    public OperatorCast(Class<R> castClass) {
        this.castClass = castClass;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> o) {
        CastSubscriber parent = new CastSubscriber(o, this.castClass);
        o.add(parent);
        return parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CastSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final Class<R> castClass;
        boolean done;

        public CastSubscriber(Subscriber<? super R> actual, Class<R> castClass) {
            this.actual = actual;
            this.castClass = castClass;
        }

        @Override
        public void onNext(T t) {
            R result;
            try {
                result = this.castClass.cast(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause(ex, t));
                return;
            }
            this.actual.onNext(result);
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaHooks.onError(e);
                return;
            }
            this.done = true;
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            this.actual.setProducer(p);
        }
    }
}

