package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Person;

/**
 * Created by mika on 2016. 12. 8..
 */
public class Bot implements Person {

  private String id;
  private String name;
  private String avatarUrl;

  @Override
  public String getId() {
    return id;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public String getAvatarUrl() {
    return avatarUrl;
  }

  public final static String CLASSNAME = "Bot";

  @Override
  public String getPersonType() {
    return Const.BOT;
  }

  @Override
  public String getPersonId() {
    return id;
  }

  @Override
  public boolean isOwnedBy(@Nullable String personType, @Nullable String personId) {
    return Const.BOT.equals(personType) && personId != null && personId.equals(id);
  }
}

