package com.zoyi.channel.plugin.android.model.etc;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;

/**
 * Created by jerry on 2018. 11. 14..
 */

public class InAppPushItem implements PopupItem {

  private long createdAt;
  @NonNull
  private ProfileEntity profile;
  @Nullable
  private String title;
  @NonNull
  private String message;
  @NonNull
  private String chatId;

  public InAppPushItem(long createdAt, @NonNull ProfileEntity profile, @Nullable String title, @NonNull String message, @NonNull String chatId) {
    this.createdAt = createdAt;
    this.profile = profile;
    this.title = title;
    this.message = message;
    this.chatId = chatId;
  }

  @NonNull
  public String getMessage() {
    return message;
  }

  @Override
  public long getCreatedAt() {
    return createdAt;
  }

  @NonNull
  @Override
  public ProfileEntity getProfile() {
    return profile;
  }

  @Nullable
  @Override
  public String getTitle() {
    return title;
  }

  @NonNull
  public String getChatId() {
    return chatId;
  }

}
