/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.content.Context;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.DataSaver;
import com.splunk.mint.InterfaceDataType;
import com.splunk.mint.LastPing;
import com.splunk.mint.Logger;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.MintUrls;
import com.splunk.mint.NetSender;
import com.splunk.mint.NetSenderResponse;
import com.splunk.mint.Properties;
import com.splunk.mint.RemoteSettings;
import com.splunk.mint.RemoteSettingsData;
import com.splunk.mint.Utils;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

class ActionEvent
extends BaseDTO
implements InterfaceDataType {
    private Long gnipTimestamp = null;
    protected String eventName = "";
    protected Integer eventLevel = null;
    protected long duration = -1L;

    public ActionEvent(byte type, String eventName, Integer level, HashMap<String, Object> customData, Long gnipTimestamp) {
        this(type, eventName, level, customData, gnipTimestamp, null);
    }

    public ActionEvent(byte type, String eventName, Integer level, HashMap<String, Object> customData, Long gnipTimestamp, String sessionID) {
        super(type, customData, sessionID);
        this.eventName = eventName;
        this.eventLevel = level;
        if (type == 3) {
            this.gnipTimestamp = gnipTimestamp;
        }
    }

    public static final ActionEvent createEvent(String eventName) {
        return new ActionEvent(1, eventName, Utils.convertLoggingLevelToInt(MintLogLevel.Verbose), null, null);
    }

    public static final ActionEvent createEvent(String eventName, MintLogLevel level, HashMap<String, Object> customData) {
        return new ActionEvent(1, eventName, Utils.convertLoggingLevelToInt(level), customData, null);
    }

    public static final ActionEvent createPing() {
        ActionEvent eventPing = new ActionEvent(2, null, null, null, null);
        return eventPing;
    }

    public static final ActionEvent createGnip(Context context) {
        ActionEvent eventGnip = new ActionEvent(3, null, null, null, null);
        eventGnip.duration = eventGnip.timestampMilis - LastPing.getLastPingSentTime(context);
        return eventGnip;
    }

    public static final ActionEvent createGnip(Context context, Long timestamp, String sessionID) {
        ActionEvent eventGnip = new ActionEvent(3, null, null, null, timestamp, sessionID);
        eventGnip.duration = eventGnip.timestampMilis - LastPing.getLastPingSentTime(context);
        return eventGnip;
    }

    @Override
    public String toJsonLine() {
        JSONObject json = this.getBasicDataFixtureJson();
        try {
            if (this.duration != -1L) {
                if (this.duration > 1000000000000L) {
                    this.duration = 1L;
                }
                json.put("ses_duration", this.duration);
            }
            if (this.eventName != null) {
                json.put("event_name", (Object)this.eventName);
            }
            if (this.eventLevel != null) {
                json.put("level", (Object)this.eventLevel);
            }
            if (this.type == 2) {
                json.put("rooted", Properties.HAS_ROOT);
                json.put("fsEncrypted", (Object)Properties.ISFSENCRYPTED);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.type == 3 && this.gnipTimestamp != null) {
            return json.toString() + Properties.getSeparator(this.type, String.valueOf(this.gnipTimestamp));
        }
        return json.toString() + Properties.getSeparator(this.type);
    }

    @Override
    public void send(Context ctx, boolean saveOnFail) {
        if (this.type == 2) {
            NetSenderResponse nsr;
            if (Properties.hecEnabled) {
                nsr = NetSender.sendBlocking(MintUrls.getURL(), this.toJsonLine(), saveOnFail);
            } else {
                StringBuilder settingsUrl = new StringBuilder();
                settingsUrl.append(MintUrls.getURL(0, 1));
                settingsUrl.append("?hash=");
                settingsUrl.append(Properties.RemoteSettingsProps.hashCode);
                nsr = NetSender.sendBlocking(settingsUrl.toString(), this.toJsonLine(), saveOnFail);
            }
            RemoteSettingsData remoteData = RemoteSettings.convertJsonToRemoteSettings(nsr.getServerResponse());
            if (remoteData != null) {
                RemoteSettings.saveAndLoadRemoteSettings(ctx, remoteData);
            }
        } else {
            NetSender.send(this.toJsonLine(), saveOnFail);
        }
    }

    @Override
    public void save() {
        if (this.eventLevel != null) {
            if (this.eventLevel >= Properties.RemoteSettingsProps.eventLevel) {
                DataSaver.save(this.toJsonLine());
            } else {
                Logger.logInfo("Event's level is lower than the minimum level from Remote Settings, event will not be saved");
            }
        } else {
            DataSaver.save(this.toJsonLine());
        }
    }

    @Override
    public void send(boolean saveOnFail) {
        NetSender.send(this.toJsonLine(), saveOnFail);
    }
}

