/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public final class ReflectionUtil {
    public static final boolean includeObject = false;

    public static Constructor<?> findConstructor(String className, Class<?>[] expectedParams) throws ClassNotFoundException {
        Constructor<?>[] constructors;
        for (Constructor<?> c : constructors = Class.forName(className).getDeclaredConstructors()) {
            Class<?>[] paramTypes = c.getParameterTypes();
            if (paramTypes.length != expectedParams.length) continue;
            boolean match = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramTypes[i].equals(expectedParams[i])) continue;
                match = false;
            }
            if (!match) continue;
            return c;
        }
        return null;
    }

    public static Set<Class<?>> getAllSuperTypes(Class<?> type) {
        HashSet result = new HashSet();
        if (type != null && !type.equals(Object.class)) {
            result.add(type);
            result.addAll(ReflectionUtil.getAllSuperTypes(type.getSuperclass()));
            for (Class<?> ifc : type.getInterfaces()) {
                result.addAll(ReflectionUtil.getAllSuperTypes(ifc));
            }
        }
        return result;
    }

    public static Set<Method> getAllMethods(Class<?> type) {
        HashSet<Method> result = new HashSet<Method>();
        for (Class<?> t : ReflectionUtil.getAllSuperTypes(type)) {
            for (Method m : t.getDeclaredMethods()) {
                result.add(m);
            }
        }
        return result;
    }

    public static String extractCallingMethod(String[] excludes) {
        Throwable t = new Throwable();
        for (StackTraceElement e : t.getStackTrace()) {
            if (ReflectionUtil.inExcluded(e.getClassName(), excludes)) continue;
            return e.getClassName() + "." + e.getMethodName() + ":" + e.getLineNumber();
        }
        return null;
    }

    public static boolean callingClassAnyOf(String[] classNames) {
        Throwable t = new Throwable();
        for (StackTraceElement e : t.getStackTrace()) {
            if (!ReflectionUtil.contains(e.getClassName(), classNames)) continue;
            return true;
        }
        return false;
    }

    public static final boolean contains(String className, String[] classes) {
        for (String s : classes) {
            if (!className.contains(s)) continue;
            return true;
        }
        return false;
    }

    private static final boolean inExcluded(String className, String[] excludes) {
        for (String s : excludes) {
            if (!className.startsWith(s)) continue;
            return true;
        }
        return false;
    }
}

