/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;

public class MenuButton
extends RelativeLayout {
    int color = -1;
    private MaskableFrameLayout mask;
    private FrameLayout colorLayout;
    private ImageView dummy;
    @Nullable
    private BigBar.MenuPosition menuPosition;
    @Nullable
    private ActionType action;
    @Nullable
    private Drawable iconId;

    public MenuButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public MenuButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MenuButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public MenuButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_menu_button, (ViewGroup)this);
        this.mask = (MaskableFrameLayout)this.findViewById(R.id.menu_icon_mask);
        this.colorLayout = (FrameLayout)this.findViewById(R.id.layout_color);
        this.dummy = (ImageView)this.findViewById(R.id.menu_icon_dummy);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MenuButton, 0, 0);
            try {
                this.color = typedArray.getColor(R.styleable.MenuButton_ch_back_color, this.color);
                this.iconId = typedArray.getDrawable(R.styleable.MenuButton_ch_image);
            }
            finally {
                typedArray.recycle();
            }
        }
        this.setIcon(this.iconId);
        this.setColor(this.color);
    }

    public void setIcon(@Nullable Drawable drawable2) {
        if (drawable2 != null) {
            this.mask.setMask(drawable2);
            this.dummy.setImageDrawable(drawable2);
        }
    }

    public void setColor(@ColorInt int color2) {
        this.colorLayout.setBackgroundColor(color2);
    }

    public void setMenuPosition(@Nullable BigBar.MenuPosition menuPosition) {
        this.menuPosition = menuPosition;
    }

    @Nullable
    public BigBar.MenuPosition getMenuPosition() {
        return this.menuPosition;
    }

    public boolean isVisible() {
        return this.getVisibility() == 0;
    }

    public void setAction(ActionType action) {
        this.action = action;
        if (action != null && action.getIcon() != 0) {
            this.mask.setMask(action.getIcon());
            this.dummy.setImageResource(action.getIcon());
        }
    }

    @Nullable
    public ActionType getAction() {
        return this.action;
    }

    public static enum MenuState {
        VISIBLE,
        DISABLED,
        HIDDEN;

    }

    public static enum ActionType {
        DONE(3),
        MORE(4),
        BACK(5),
        EXIT(6),
        CAMERA(7),
        REFRESH(8),
        DELETE(9),
        SETTINGS(10);

        private final int value;

        private ActionType(int value) {
            this.value = value;
        }

        public int getIcon() {
            if (this.value == ActionType.DONE.value) {
                return R.drawable.ch_plugin_ic_done_white_24dp;
            }
            if (this.value == ActionType.MORE.value) {
                return R.drawable.ch_plugin_menu;
            }
            if (this.value == ActionType.BACK.value) {
                return R.drawable.ch_plugin_chevron_left;
            }
            if (this.value == ActionType.EXIT.value) {
                return R.drawable.ch_plugin_exit_white;
            }
            if (this.value == ActionType.CAMERA.value) {
                return R.drawable.ch_plugin_ic_photo_camera_white_24dp;
            }
            if (this.value == ActionType.REFRESH.value) {
                return R.drawable.ch_plugin_bar_refresh;
            }
            if (this.value == ActionType.DELETE.value) {
                return R.drawable.ch_plugin_delete;
            }
            if (this.value == ActionType.SETTINGS.value) {
                return R.drawable.ch_plugin_settings;
            }
            return 0;
        }
    }
}

