/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItem;
import com.zoyi.channel.plugin.android.activity.userchat_list.model.ChatListItemType;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.MessageSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class UserChatItem
implements ChatListItem {
    @NonNull
    private UserChat userChat;

    public UserChatItem(@NonNull UserChat userChat) {
        this.userChat = userChat;
    }

    @NonNull
    public UserChat getUserChat() {
        return this.userChat;
    }

    public void setUserChat(@NonNull UserChat userChat) {
        this.userChat = userChat;
    }

    @Override
    @NonNull
    public String getId() {
        return this.userChat.getId();
    }

    @Override
    @Nullable
    public ProfileEntity getProfile() {
        return ProfileSelector.getHostProfile(this.userChat.getHostType(), this.userChat.getHostId());
    }

    @Nullable
    public Message getLastMessage() {
        return MessageSelector.get(this.userChat.getLastMessageId());
    }

    @Override
    public String getAlert() {
        return CounterSelector.getChatCounter(this.userChat.getId());
    }

    @Override
    @NonNull
    public String getUpdatedDate() {
        if (this.userChat.isStateClosed() && this.userChat.getClosedAt() != null) {
            return TimeUtils.get(this.userChat.getClosedAt());
        }
        if (this.userChat.getUpdatedAt() != null) {
            return TimeUtils.get(this.userChat.getUpdatedAt());
        }
        return "";
    }

    @Override
    public ChatListItemType getItemType() {
        return ChatListItemType.USER_CHAT;
    }

    @Nullable
    public String getHostType() {
        return this.userChat.getHostType();
    }

    @Nullable
    public String getHostId() {
        return this.userChat.getHostId();
    }

    @Override
    @NonNull
    public Long getPrimaryKey() {
        if (this.userChat.getUpdatedAt() != null) {
            return this.userChat.getUpdatedAt();
        }
        return 0L;
    }

    @Override
    @NonNull
    public String getSecondaryKey() {
        return this.userChat.getId();
    }
}

