package com.zoyi.channel.plugin.android.push;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.Guest;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.selector.PluginSelector;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.wrapper.CHDefaultEvent;

public class ChannelPushClient {

  public static void handlePushNotification(final Context context) {
    ChannelPushManager.clearNotification(context);
    if (PrefSupervisor.hasPushChatId(context) && PrefSupervisor.hasBootFlag(context)) {
      if (ChannelIO.isBooted()) {
        launchChat(context);
      } else {
        if (ChannelIO.isInitializedChannelIO()) {
          ChannelPluginSettings pluginSettings = PrefSupervisor.getPluginSetting(context);

          if (pluginSettings != null) {
            ChannelIO.boot(
                pluginSettings,
                new OnBootListener() {
                  @Override
                  public void onCompletion(ChannelPluginCompletionStatus status, @Nullable Guest guest) {
                    switch (status) {
                      case SUCCESS:
                        launchChat(context);
                        break;
                      case NOT_INITIALIZED:
                        L.e("Push Notification : This plugin is Not initialized");
                        break;
                      case NETWORK_TIMEOUT:
                        L.e("Push Notification : Network timeout error!");
                        break;
                      case ACCESS_DENIED:
                        L.e("Push Notification : Access denied!");
                        break;
                      case REQUIRE_PAYMENT:
                        L.e("Push Notification : Require payment!");
                        break;
                      case NOT_AVAILABLE_VERSION:
                        L.e("Push Notification : Check Plugin version");
                        break;
                      case SERVICE_UNDER_CONSTRUCTION:
                        L.e("Push Notification : Service is now under construction");
                        break;
                      default:
                        L.e("Push Notification : Unknown error");
                        break;
                    }
                  }
                });
          } else {
            L.e("Push Notification : This plugin is Not initialized");
          }
        } else {
          L.e("Push Notification : This plugin is Not initialized");
        }
      }
    } else {
      L.e("Push Notification : Invalid push notification data");
    }
  }

  private static void launchChat(Context context) {
    String chatId = PrefSupervisor.getPushChatId(context);

    if (!TextUtils.isEmpty(chatId)) {
      IntentUtils
          .setNextActivity(context, UserChatListActivity.class)
          .setTransition(Transition.SLIDE_FROM_BOTTOM)
          .putExtra(Const.EXTRA_CHAT_ID, chatId)
          .startActivity();
    } else {
      L.e("Fail to open ChannelIO messenger, 'chatId' can't be NULL");
    }
    PrefSupervisor.clearPushChatId(context);
  }

}
