/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.userchat_list.model;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.base.SortableItem;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.selector.CounterSelector;
import com.zoyi.channel.plugin.android.selector.MessageSelector;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class UserChatItem
implements SortableItem {
    @Nullable
    private UserChat userChat;

    public UserChatItem(@NonNull UserChat userChat) {
        this.userChat = userChat;
    }

    @Nullable
    public UserChat getUserChat() {
        return this.userChat;
    }

    public void setUserChat(@Nullable UserChat userChat) {
        if (userChat != null) {
            this.userChat = userChat;
        }
    }

    @NonNull
    public String getId() {
        if (this.userChat != null && this.userChat.getId() != null) {
            return this.userChat.getId();
        }
        return "";
    }

    @Nullable
    public ProfileEntity getProfile() {
        if (this.userChat != null) {
            return ProfileSelector.getHostProfile(this.userChat.getHostType(), this.userChat.getHostId());
        }
        return null;
    }

    @NonNull
    public String getHostName(Context context) {
        if (this.userChat != null) {
            return ProfileSelector.getPersonName(context, this.userChat.getHostType(), this.userChat.getHostId());
        }
        return ResUtils.getString(context, "ch.unknown");
    }

    @Nullable
    public Message getLastMessage() {
        if (this.userChat != null) {
            return MessageSelector.get(this.userChat.getLastMessageId());
        }
        return null;
    }

    public String getAlert() {
        return CounterSelector.getChatCounter(this.getId());
    }

    @NonNull
    public String getUpdatedDate() {
        if (this.userChat != null) {
            if (this.userChat.isStateClosed() && this.userChat.getClosedAt() != null) {
                return TimeUtils.get(this.userChat.getClosedAt());
            }
            if (this.userChat.getUpdatedAt() != null) {
                return TimeUtils.get(this.userChat.getUpdatedAt());
            }
        }
        return "";
    }

    @Nullable
    public String getHostType() {
        if (this.userChat != null) {
            return this.userChat.getHostType();
        }
        return null;
    }

    @Nullable
    public String getHostId() {
        if (this.userChat != null) {
            return this.userChat.getHostId();
        }
        return null;
    }

    @Override
    @NonNull
    public Long getPrimaryKey() {
        if (this.userChat != null && this.userChat.getUpdatedAt() != null) {
            return this.userChat.getUpdatedAt();
        }
        return 0L;
    }

    @Override
    @NonNull
    public String getSecondaryKey() {
        return this.getId();
    }
}

