package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnFormMessageClickListener;
import com.zoyi.channel.plugin.android.model.ActionInput;
import com.zoyi.channel.plugin.android.activity.chat.model.FormMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonLayout;
import com.zoyi.channel.plugin.android.activity.chat.view.form.FormButtonView;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.Utils;

/**
 * Created by jerry on 2018. 6. 11..
 */

public class FormMessageHolder extends TextMessageHolder {

  private Context context;

  private LinearLayout extraMessageContentLayout;
  private FormButtonLayout formButtonLayout;

  @Nullable
  private OnFormMessageClickListener onClickListener;

  public static FormMessageHolder newInstance(
      ViewGroup parent,
      MessageType messageType,
      @Nullable OnFormMessageClickListener onClickListener) {
    return new FormMessageHolder(getItemView(parent, messageType), onClickListener);
  }

  public FormMessageHolder(
      View itemView,
      @Nullable OnFormMessageClickListener onClickListener) {
    super(itemView, MessageType.FORM_MESSAGE, onClickListener);
    this.context = itemView.getContext();
    this.onClickListener = onClickListener;

    extraMessageContentLayout = itemView.findViewById(R.id.ch_message_content_extra);
    formButtonLayout = itemView.findViewById(R.id.ch_layout_form_button);
  }

  public void bind(ChatMessageItem chatItem, boolean isLastMessage, boolean isConnected) {
    super.bind(chatItem, isConnected);

    FormMessageItem formMessageItem = new FormMessageItem(chatItem.getMessage());

    if (!isLastMessage || !ListUtils.hasItems(formMessageItem.getActionInputs())) {
      extraMessageContentLayout.setVisibility(View.GONE);
    } else {
      extraMessageContentLayout.setVisibility(View.VISIBLE);

      formButtonLayout.removeAllViews();
      formButtonLayout.refresh();
      formButtonLayout.setWidth(getButtonLayoutWidth(context));

      for (ActionInput actionInput : formMessageItem.getActionInputs()) {
        addFormButton(formMessageItem.getActionType(), actionInput);
      }
    }
  }

  private void addFormButton(@Nullable String actionType, ActionInput actionInput) {
    FormButtonView formButtonView = new FormButtonView(context, actionType, actionInput, onClickListener);
    formButtonLayout.add(formButtonView);
  }

  // ch_plugin_item_message_form paddingStart, paddingEnd 값과 일치해야함
  private int getButtonLayoutWidth(Context context) {
    int windowWidth = Utils.getWindowSize(context).x;
    int leftPadding = (int) Utils.dpToPx(context, 110f);
    int rightPadding = (int) Utils.dpToPx(context, 10f);

    return windowWidth - (leftPadding + rightPadding);
  }
}
