/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.store;

import android.support.annotation.ColorInt;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.store.SingleStore;

public class PluginStore
extends SingleStore<Plugin> {
    private String pluginKey;
    @ColorInt
    private int backgroundColor = -16777216;
    @ColorInt
    private int textColor = -1;

    @Override
    public void set(Plugin plugin) {
        super.set(plugin);
        if (plugin != null) {
            this.pluginKey = plugin.getKey();
            this.backgroundColor = plugin.getBackgroundColor();
            this.textColor = plugin.getTextColor();
        }
    }

    @Override
    protected boolean canUpdate(Plugin plugin) {
        return this.pluginKey != null && this.pluginKey.equals(plugin.getKey());
    }

    @Override
    public void clearData() {
        super.clearData();
        this.pluginKey = null;
        this.backgroundColor = -16777216;
        this.textColor = -1;
    }

    @Override
    protected StoreType getStoreType() {
        return StoreType.PLUGIN;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getTextColor() {
        return this.textColor;
    }
}

