package com.zoyi.channel.plugin.android.activity.settings.setting_language;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.settings.setting_language.listener.OnLanguageItemClickListener;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.view.layout.BigBar;
import com.zoyi.channel.plugin.android.view.layout.MenuButton;
import com.zoyi.channel.plugin.android.view.layout.SelectableLanguageItem;

import java.util.ArrayList;
import java.util.List;

public class SettingLanguageActivity extends BaseActivity implements OnLanguageItemClickListener {

  private SettingLanguagePresenter presenter;

  private LinearLayout contentLayout;
  private List<CHLocale> channelLanguages;

  private CHLocale selectedChannelLanguage;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_setting_language);

    presenter = new SettingLanguagePresenter();

    initData();
    initView();
  }

  private void initData() {
    channelLanguages = new ArrayList<>();
    channelLanguages.add(CHLocale.KOREAN);
    channelLanguages.add(CHLocale.JAPANESE);
    channelLanguages.add(CHLocale.ENGLISH);

    selectedChannelLanguage = CHLocale.fromString(PrefSupervisor.getPluginLanguage(this));
  }

  private void initView() {
    if (getBigBar() != null) {
      getBigBar().withActivity(this)
          .addMenu(MenuButton.ActionType.BACK, BigBar.MenuPosition.LEFT)
          .build();
      getBigBar().setTitleByKey("ch.user_profile.locale.label");
    }

    contentLayout = findViewById(R.id.ch_layout_setting_language);

    for (CHLocale channelLanguage : channelLanguages) {
      SelectableLanguageItem selectableLanguageItem = new SelectableLanguageItem(this);
      selectableLanguageItem.setLanguage(channelLanguage);
      selectableLanguageItem.setListener(this);
      selectableLanguageItem.setSelectedLanguage(selectedChannelLanguage == channelLanguage);

      contentLayout.addView(selectableLanguageItem);
    }
  }

  @Override
  public void onItemClick(CHLocale channelLanguage) {
    selectedChannelLanguage = channelLanguage;

    for (int i = 0; i < contentLayout.getChildCount(); i++) {
      SelectableLanguageItem languageItem = (SelectableLanguageItem) contentLayout.getChildAt(i);
      if (selectedChannelLanguage != languageItem.getLanguage()) {
        languageItem.setStyle(false);
      }
    }

    presenter.changeLanguage(this, selectedChannelLanguage);
    setResult(Const.RESULT_CHANGE_LOCALE);
    finish();
  }
}
