package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageReviewListener;
import com.zoyi.channel.plugin.android.global.Const;

public class ResolveMessageHolder extends RecyclerView.ViewHolder implements View.OnClickListener {

  @Nullable
  private OnMessageReviewListener listener;

  public ResolveMessageHolder(View itemView, @Nullable OnMessageReviewListener listener) {
    super(itemView);

    this.listener = listener;

    itemView.findViewById(R.id.iv_user_chat_review_close).setOnClickListener(this);
    itemView.findViewById(R.id.tv_user_chat_dislike).setOnClickListener(this);
    itemView.findViewById(R.id.tv_user_chat_like).setOnClickListener(this);
  }

  @Override
  public void onClick(View v) {
    if (listener != null) {
      int id = v.getId();

      if (id == R.id.iv_user_chat_review_close) {
        listener.onMessageReview(null);
      }
      if (id == R.id.tv_user_chat_dislike) {
        listener.onMessageReview(Const.USER_CHAT_REVIEW_DISLIKE);
      }
      if (id == R.id.tv_user_chat_like) {
        listener.onMessageReview(Const.USER_CHAT_REVIEW_LIKE);
      }
    }
  }
}
