package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnImageMessageClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.MaskableFrameLayout;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.zoyi.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.zoyi.com.bumptech.glide.request.RequestListener;
import com.zoyi.com.bumptech.glide.request.target.Target;

/**
 * Created by jerry on 2018. 3. 28..
 */

public class ImageMessageHolder extends TextMessageHolder {

  private Context context;

  protected MaskableFrameLayout imageLayout;
  protected ImageView imagePlaceholder;
  protected ImageView imageContent;

  @Nullable
  private Message message;
  private Point previewImageSize;

  @Nullable
  private OnImageMessageClickListener listener;

  public static ImageMessageHolder newInstance(
      ViewGroup parent,
      MessageType messageType,
      @Nullable OnImageMessageClickListener listener) {
    return new ImageMessageHolder(getItemView(parent, messageType), messageType, listener);
  }

  public ImageMessageHolder(View itemView, MessageType messageType, @Nullable OnImageMessageClickListener listener) {
    super(itemView, messageType, listener);
    this.context = itemView.getContext();
    this.listener = listener;

    imageLayout = itemView.findViewById(R.id.ch_message_content_image);
    imagePlaceholder = itemView.findViewById(R.id.image_placeholder);
    imageContent = itemView.findViewById(R.id.image_chat);

    imageContent.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        onImageClick();
      }
    });

    previewImageSize = new Point();
  }

  @Override
  public void bind(ChatMessageItem item, boolean isConnectedMessage) {
    super.bind(item, isConnectedMessage);

    message = item.getMessage();
    if (message != null) {
      File file = message.getFile();

      if (file != null) {
        setImageMessage(file.getPreviewThumb(), false, message.getMessage());
      }
    }
  }

  protected void setImageMessage(PreviewThumb preview, boolean isWebPage, String message) {
    int width, height;

    Point windowSize = Utils.getWindowSize(context);

    if (isWebPage) {
      // MarginLeft = 115dp
      width = windowSize.x - (int) Utils.dpToPx(context, 115f);
      height = (int) (width * 0.52);

      previewImageSize.set(width, height);
    } else {
      previewImageSize = Utils.resizeImage(context, new Point(preview.getWidth(), preview.getHeight()));
    }

    LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) imageLayout.getLayoutParams();
    params.width = previewImageSize.x;
    params.height = previewImageSize.y;
    int marginTop = (int) Utils.dpToPx(context, 8f);
    params.setMargins(0, marginTop, 0, 0);

    imageLayout.setLayoutParams(params);
    imageLayout.setVisibility(View.VISIBLE);
    imagePlaceholder.setVisibility(View.VISIBLE);

    Glide.with(itemView.getContext())
        .load(preview.getUrl())
        .diskCacheStrategy(DiskCacheStrategy.SOURCE)
        .override(previewImageSize.x, previewImageSize.y)
        .centerCrop()
        .listener(new RequestListener<String, GlideDrawable>() {
          @Override
          public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
            L.e(e.getMessage());
            return false;
          }

          @Override
          public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
            imagePlaceholder.setVisibility(View.GONE);
            return false;
          }
        })
        .into(imageContent);
  }

  protected Point getPreviewImageSize() {
    return previewImageSize;
  }

  protected void onImageClick() {
    if (listener != null && message != null) {
      listener.onImageClick(message.getFile());
    }
  }
}
