package com.zoyi.channel.plugin.android.activity.chat;

import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.AnimRes;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageButton;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity;
import com.zoyi.channel.plugin.android.activity.chat.model.SendingMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatResponseManager;
import com.zoyi.channel.plugin.android.activity.download.DownloadActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumActivity;
import com.zoyi.channel.plugin.android.activity.photo_album.PhotoAlbumStorage;
import com.zoyi.channel.plugin.android.activity.photo_picker.PhotoPickerActivity;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.activity.video.VideoViewerActivity;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.enumerate.StoreType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.enumerate.UpdateType;
import com.zoyi.channel.plugin.android.event.LinkableMessageBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TopNavBus;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.Person;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.selector.*;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.Store;
import com.zoyi.channel.plugin.android.store.TranslationStore;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;
import com.zoyi.channel.plugin.android.view.handler.BackgroundToucher;
import com.zoyi.channel.plugin.android.view.handler.EditTextChangedListener;
import com.zoyi.channel.plugin.android.view.handler.InfiniteScrollListener;
import com.zoyi.channel.plugin.android.view.layout.*;
import com.zoyi.channel.plugin.android.view.layout.BigBar.MenuPosition;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.ActionType;
import com.zoyi.channel.plugin.android.view.layout.MenuButton.MenuState;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.functions.Action1;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by mika on 2016. 12. 7..
 */
public class ChatActivity
    extends BaseActivity
    implements
    ChatContract.View,
    EditTextChangedListener,
    View.OnClickListener,
    TopNavFragment.OnChatTopNavListener {

  private static final int DELAY_EXPAND_COLLAPSE = 512;

  private TopNavFragment topNavFragment;
  private ChatRecyclerView chatList;
  private WatchedEditText editChat;
  private ImageButton imageSend;
  private View layoutInput;
  private PreviewFragment previewFragment;
  private ChatCompltedFragment completedFragment;
  private WaterMarkLayout waterMarkLayout;
  private CHTextView disabledInputText;
  @Nullable
  private BigBar bigBar;

  private LinearLayoutManager layoutManager;
  private TypingManager typingManager;

  private ChatContract.Presenter presenter;

  private ChatAdapter adapter;

  private Subscription subscription;
  @Nullable
  private Subscription countSubscription;

  private int enterAnimInCreate;
  private int existAnimInFinish;
  private boolean exit = false;

  @Override
  protected void onCreate(@Nullable Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    init(R.layout.ch_plugin_activity_chat);

    String chatId = null;

    if (getIntent() != null) {
      chatId = getIntent().getStringExtra(Const.EXTRA_CHAT_ID);
    }
    bigBar = getBigBar();

    initBigBar();

    FragmentManager fm = getSupportFragmentManager();

    topNavFragment = (TopNavFragment) fm.findFragmentById(R.id.f_chat_top_nav);
    topNavFragment.setOnChatTopNavListener(this);

    presenter = new ChatPresenter(this);
    adapter = new ChatAdapter(TextUtils.isEmpty(chatId));

    presenter.setView(this);
    presenter.setAdapterModel(adapter);
    presenter.setAdapterView(adapter);
    presenter.setChatId(chatId);

    layoutManager = new LinearLayoutManager(this);
    layoutManager.setStackFromEnd(true);
    chatList = (ChatRecyclerView) findViewById(R.id.recycler_chat);
    chatList.setLayoutManager(layoutManager);
    chatList.setAdapter(adapter);
    chatList.setItemAnimator(null);
    chatList.addOnLayoutChangeListener(new View.OnLayoutChangeListener() {
      @Override
      public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (bottom < oldBottom) {
          collapseTopNav(true);
        }
      }
    });
    chatList.setTopNavFragment(topNavFragment);
    chatList.addOnScrollListener(new InfiniteScrollListener(
        layoutManager,
        InfiniteScrollListener.TOP,
        chatList) {
      @Override
      public void scrolledInList() {}

      @Override
      public void scrollAttachedToBottom() {
        previewFragment.hide();
      }

      @Override
      public void refresh() {
        presenter.fetchBackwardMessages();
      }
    });

    waterMarkLayout = (WaterMarkLayout) findViewById(R.id.chat_layout_water_mark);
    setWaterMarkLayout();

    findViewById(R.id.button_attach).setOnClickListener(this);

    imageSend = (ImageButton) findViewById(R.id.iv_chat_send);
    imageSend.setOnClickListener(this);

    editChat = (WatchedEditText) findViewById(R.id.edit_chat);
    editChat.setWatchedTextChangedListener(this);
    editChat.setOnFocusChangeListener(new View.OnFocusChangeListener() {
      @Override
      public void onFocusChange(View v, boolean hasFocus) {
        adapter.setChatEditTextFocus(hasFocus);
      }
    });
    editChat.setText(PrefSupervisor.getStoredMessage(this));
    PrefSupervisor.clearStoredMessage(this);

    layoutInput = findViewById(R.id.layout_input);
    disabledInputText = findViewById(R.id.text_disabled_input);

    setDisabledInputBoxView(false);

    previewFragment = (PreviewFragment) fm.findFragmentById(R.id.f_chat_preview);
    completedFragment = (ChatCompltedFragment) fm.findFragmentById(R.id.f_chat_completed);

    BackgroundToucher.makeKeyboardEvent(this, chatList, editChat);

    setStyle();

    presenter.init(chatId);

    typingManager = new TypingManager(chatId, UserChat.CLASSNAME, editChat);

    if (SocketManager.isError()) {
      setReconnectVisibility(true);
    }

    subscribe();
  }

  private void setWaterMarkLayout() {
    final Channel channel = ChannelSelector.getCurrentChannel();

    if (channel != null && channel.isTrial()) {
      waterMarkLayout.setVisibility(View.VISIBLE);
      waterMarkLayout.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          Executor.goWeb(getBaseContext(),
              String.format(
                  Const.UTM_URL,
                  PrefSupervisor.getPluginLanguage(ChatActivity.this),
                  "plugin_watermark",
                  channel.getName(),
                  channel.getId()));
        }
      });

      chatList.addOnScrollListener(new InfiniteScrollListener(
          layoutManager,
          InfiniteScrollListener.TOP,
          chatList) {

        @Override
        public void scrolledInList() {
          waterMarkLayout.setVisibility(View.GONE);
        }

        @Override
        public void scrollAttachedToBottom() {
          waterMarkLayout.setVisibility(View.VISIBLE);
        }

        @Override
        public void refresh() {}
      });
    } else {
      waterMarkLayout.setVisibility(View.GONE);
      chatList.setPadding(0, 0, 0, 0);
    }
  }

  @Override
  protected void onDestroy() {
    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
    }
    if (countSubscription != null && !countSubscription.isUnsubscribed()) {
      countSubscription.unsubscribe();
    }
    Store.getInstance(TranslationStore.class).clearData();
    super.onDestroy();
  }

  @Override
  public void finish() {
    if (presenter != null && presenter.getChatId() != null) {
      presenter.leaveChat();
    }
    super.finish();
  }

  private void initBigBar() {
    if (bigBar != null) {
      bigBar.withActivity(this)
          .addMenu(
              ActionType.SETTINGS,
              MenuPosition.LEFT,
              MenuState.HIDDEN)
          .addMenu(
              ActionType.BACK,
              MenuPosition.LEFT,
              MenuState.HIDDEN)
          .addText(MenuPosition.LEFT)
          .addMenu(ActionType.REFRESH, MenuPosition.RIGHT, MenuState.HIDDEN)
          .addMenu(ActionType.EXIT, MenuPosition.RIGHT)
          .build();
    }

    refreshChatCount(true);
    refreshMenuButton();
  }

  private void refreshChatCount(boolean force) {
    if (force) {
      if (bigBar != null) {
        bigBar.setText(CounterSelector.getTotalCounter());
      }
    } else {
      if (countSubscription != null && !countSubscription.isUnsubscribed()) {
        countSubscription.unsubscribe();
      }
      countSubscription = Observable.timer(600, TimeUnit.MILLISECONDS)
          .observeOn(AndroidSchedulers.mainThread())
          .subscribe(new Action1<Long>() {
            @Override
            public void call(Long aLong) {
              if (bigBar != null) {
                bigBar.setText(CounterSelector.getTotalCounter());
              }
            }
          });
    }
  }

  private void refreshMenuButton() {
    if (bigBar != null) {
      if (UserChatSelector.getUserChatCount() > 0 || (presenter != null && presenter.getUserChat() != null)) {
        bigBar.setMenuState(ActionType.BACK, MenuState.VISIBLE);
        bigBar.setMenuState(ActionType.SETTINGS, MenuState.HIDDEN);
      } else {
        bigBar.setMenuState(ActionType.BACK, MenuState.HIDDEN);
        bigBar.setMenuState(ActionType.SETTINGS, MenuState.VISIBLE);
      }
    }
  }

  private void setStyle() {
    if (bigBar != null) {
      bigBar.setImageLeftOfTitle(R.drawable.ch_plugin_normal_w);
      bigBar.getImageLeftOfTitle().setVisibility(View.INVISIBLE);
      bigBar.setImageRightOfTitle(
          ColorSelector.getTextColor() == Color.WHITE
              ? R.drawable.ch_plugin_dropdown_arrow_down
              : R.drawable.ch_plugin_dropdown_arrow_down_b);
    }

    Channel channel = ChannelSelector.getCurrentChannel();
    if (channel != null && bigBar != null) {
      bigBar.setTitle(channel.getName());
    }
  }

  private void setDisabledInputBoxView(boolean isSocketEvent) {
    Channel channel = ChannelSelector.getCurrentChannel();

    if (channel != null) {
      if (isSocketEvent) {
        if (channel.isWorking() || Const.AWAY_OPTION_ACTIVE.equals(channel.getAwayOption())) {
          setDisabledInputBoxVisibility(false);
        }
      } else {
        if (!channel.isWorking() && Const.AWAY_OPTION_DISABLED.equals(channel.getAwayOption())) {
          setDisabledInputBoxVisibility(true);
        } else {
          setDisabledInputBoxVisibility(false);
        }
      }
    } else {
      setDisabledInputBoxVisibility(false);
    }
  }

  private void setDisabledInputBoxVisibility(boolean isDisabled) {
    disabledInputText.setVisibility(UIUtils.getVisible(isDisabled, true));
    layoutInput.setVisibility(UIUtils.getVisible(!isDisabled, true));
  }

  private void subscribe() {
    subscription = RxBus.observable().subscribe(new Action1<Object>() {
      @Override
      public void call(Object o) {
        if (o != null) {
          if (o instanceof TopNavBus.Change) {
            changeBigBar(((TopNavBus.Change) o).expand);
          }
        }
      }
    });
  }

  private void changeBigBar(boolean expand) {
    if (bigBar != null) {
      Plugin plugin = PluginSelector.getPlugin();
      Channel channel = ChannelSelector.getCurrentChannel();
      UserChat userChat = presenter.getUserChat();

      bigBar.getImageRightOfTitle().setRotation(expand ? -180f : 0f);

      if (userChat == null || userChat.isStateReady() || userChat.isStateOpen()) {
        bigBar.setImageLeftOfTitle(ChatResponseManager.getResponseSymbol(channel));
        bigBar.setTitle(channel == null
            ? ResUtils.getString(this, "ch.unknown")
            : channel.getName());
        bigBar
            .setSubTitleByKey(ChatResponseManager.getShortResponseDescriptionKey(channel))
            .setSubTitleVisibility(!expand);
      } else {
        ProfileEntity entity = ProfileSelector.getHostProfile(userChat.getHostType(), userChat.getHostId());

        bigBar.setImageLeftOfTitle(ChatResponseManager.getManagerOnlineSymbol(plugin, entity));
        bigBar.setTitle(entity == null ? "" : entity.getName());
        bigBar.setSubTitleVisibility(false);
      }

      if (expand) {
        bigBar.getImageLeftOfTitle().setVisibility(View.INVISIBLE);
      }
    }
  }

  @Override
  public void onLoadUserChat(@Nullable UserChat userChat, boolean create) {
    if (userChat != null) {
      typingManager.setChatId(userChat.getId());
    }

    if (userChat == null || userChat.isStateReady() || userChat.isStateOpen()) {
      topNavFragment.set(ManagerSelector.getFollowingManagers());

      if (userChat == null) {
        expandTopNav(false);
      } else {
        collapseTopNav(true);
      }
    } else {
      Person person = ProfileSelector.getPerson(userChat.getHostType(), userChat.getHostId());

      topNavFragment.set(person);
      collapseTopNav(true);
    }

    if (bigBar != null) {
      bigBar.setOnClickListener(this);
    }

    refreshMenuButton();
  }

  @Override
  public void updateBackwardId(@Nullable String backwardId) {
    chatList.setBackwardId(backwardId);
  }

  @Override
  public void setInputLayoutVisibility() {
    if (presenter.isStateCompleted()) {
      Keyboard.close(this, editChat);

      completedFragment.show(editChat.getText().toString().trim());
      layoutInput.setVisibility(View.GONE);
      disabledInputText.setVisibility(View.GONE);
    } else {
      completedFragment.hide();
      layoutInput.setVisibility(View.VISIBLE);
      disabledInputText.setVisibility(View.GONE);
    }
  }

  @Override
  public boolean isMovableToBottomPosition() {
    int lastPosition = layoutManager.findLastVisibleItemPosition();
    return lastPosition <= adapter.getItemCount() - 2 && lastPosition >= adapter.getItemCount() - 4;
  }

  @Override
  public boolean isBottomPosition() {
    return layoutManager.findLastCompletelyVisibleItemPosition() >= adapter.getItemCount() - 2;
  }

  @Override
  public void scrollToPosition(int position) {
    layoutManager.scrollToPosition(position);
  }

  @Override
  public void scrollToBottom(boolean force) {
    if (layoutManager.findLastCompletelyVisibleItemPosition() == adapter.getItemCount() - 2 || force) {
      layoutManager.scrollToPosition(adapter.getItemCount() - 1);
    }
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    super.onActivityResult(requestCode, resultCode, data);
    switch (requestCode) {
      case Const.PHOTO_REQUEST_CODE:
        if (resultCode == Const.PHOTO_RESULT_CODE) {
          presenter.sendImageFiles(data.getStringArrayListExtra(Const.PHOTO_INTENT_KEY));
          collapseTopNav(true);
        }
        break;

      case Const.REQUEST_PHOTO_ALBUM:
        PhotoAlbumStorage.getInstance().release();
        break;

      case Const.REQUEST_PLUGIIN_SETTINGS:
        if (resultCode == Const.RESULT_CHAT_OPTION_CHANGED) {
          setResult(Const.RESULT_CHAT_OPTION_CHANGED);
        }
        break;
    }
  }

  @Override
  protected void receiveRxEvent(Object o) {
    super.receiveRxEvent(o);
    if (o instanceof LinkableMessageBus) {
      LinkableMessageBus linkable = (LinkableMessageBus) o;
      onClickLinkableMessage(linkable.getMessage(), linkable.getLinkType());
    }
  }

  @Override
  public void receiveCommand(Command command, @Nullable Object object) {
    presenter.receiveCommand(command, object);
  }

  @Override
  public void receiveData(Entity entity, boolean upsert) {
    presenter.receiveData(entity, upsert);
  }

  @Override
  public void receiveStoreEvent(StoreType storeType, UpdateType updateType, @Nullable Entity entity) {
    switch (storeType) {
      case USER:
      case VEIL:
        refreshChatCount(false);
        break;

      case USER_CHAT:
        refreshMenuButton();
        break;
    }
  }

  @Override
  public void receiveTyping(Typing typing) {
    if (typing != null
        && typing.isOther()
        && typing.isSameChat(presenter.getChatId(), UserChat.CLASSNAME)) {
      typingManager.addTTLTimer(typing);

      presenter.receiveTyping(typing);
    }
  }

  @Override
  public void receiveLanguageEvent() {
    presenter.receiveLanguageEvent();
  }

  @Override
  public void optionClicked(ActionType actionType) {
    switch (actionType) {
      case REFRESH:
        presenter.refresh();
        break;
      case SETTINGS:
        IntentUtils.setNextActivity(this, SettingsActivity.class)
            .setTransition(Transition.SLIDE_FROM_BOTTOM)
            .startActivityForResult(Const.REQUEST_PLUGIIN_SETTINGS);
        break;
      case BACK:
        onBackPressed();
        break;
      case EXIT:
        goToMain();
        break;
    }
  }

  @Override
  public void setRefreshVisibility(boolean showRefresh) {
    if (bigBar != null) {
      bigBar.setMenuState(ActionType.REFRESH, showRefresh ? MenuState.VISIBLE : MenuState.HIDDEN);
    }
  }

  @Override
  public void setReconnectVisibility(boolean show) {
    topNavFragment.setReconnectVisibility(show);
  }

  @Override
  public void setChannel(Channel channel) {
    changeBigBar(topNavFragment.isExpand());
    setDisabledInputBoxView(true);

    topNavFragment.setChannel(channel);
    if (topNavFragment.isExpand()) {
      chatList.setTranslationY(topNavFragment.getExpectHeight());
    }
  }

  @Override
  public void changeBigBar() {
    changeBigBar(topNavFragment.isExpand());
  }

  @Override
  public void processNewMessage(@Nullable ProfileEntity profileEntity, @Nullable Message message) {
    if (profileEntity == null || message == null || message.getLog() != null) {
      return;
    }

    if (layoutManager.canScrollVertically() && !isBottomPosition()) {
      previewFragment.show(profileEntity);
    }
  }

  @Override
  public void setPerson(@Nullable Person person) {
    topNavFragment.set(person);

    if (topNavFragment.isExpand()) {
      chatList.setTranslationY(topNavFragment.getExpectHeight());
    }
  }

  @Override
  public void onRemovedChat() {
    finish();
  }

  @Override
  public void onWatchedTextChanged(String s) {
    imageSend.setEnabled(!TextUtils.isEmpty(s.trim()));
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();

    if (id == R.id.button_attach) {
      hideKeyboard(editChat);
      IntentUtils.setNextActivity(ChatActivity.this, PhotoPickerActivity.class)
          .startActivityForResult(Const.PHOTO_REQUEST_CODE);
    }
    if (id == R.id.iv_chat_send) {
      presenter.sendTextMessage(editChat.getString());
      editChat.setText("");

      topNavFragment.collapse();
    }
    if (id == R.id.big_bar) {
      if (chatList.isScrolling()) {
        return;
      }

      if (topNavFragment.isExpand()) {
        collapseTopNav(true);
      } else {
        expandTopNav(true);
      }
    }
  }

  private void collapseTopNav(boolean immediately) {
    new Handler().postDelayed(new Runnable() {
      @Override
      public void run() {
        topNavFragment.collapse();
        chatList.setTranslationY(0, true);
      }
    }, immediately ? 0 : DELAY_EXPAND_COLLAPSE);
  }

  private void expandTopNav(boolean immediately) {
    new Handler().postDelayed(new Runnable() {
      @Override
      public void run() {
        int topNavHeight = topNavFragment.getExpectHeight();
        hideKeyboard(editChat);

        topNavFragment.setTranslationY(-topNavHeight);
        topNavFragment.expand();

        if (chatList.canScrollVertically(ChatRecyclerView.DIRECTION_SCROLLING_DOWN)) {
          changeBigBar(true);
        } else {
          changeBigBar(topNavHeight > 0);
        }
      }
    }, immediately ? 0 : DELAY_EXPAND_COLLAPSE);
  }

  @Override
  public void onClickTopNav() {
    if (chatList.isScrolling()) {
      return;
    }
    topNavFragment.collapse();
  }

  @Override
  public void onFileDownload(File file) {
    if (file.getType() != null && file.getType().startsWith("video")) {
      IntentUtils.setNextActivity(this, VideoViewerActivity.class)
          .putExtra(Const.EXTRA_FILE_NAME, file.getName())
          .putExtra(Const.EXTRA_URL, file.getUrl())
          .startActivity();
    } else {
      IntentUtils.setNextActivity(this, DownloadActivity.class)
          .putExtra(Const.EXTRA_URL, file.getUrl())
          .putExtra(Const.EXTRA_FILE_NAME, file.getFilename())
          .putExtra(Const.EXTRA_IMAGE, file.isImage())
          .setTransition(Transition.NONE)
          .startActivity();
    }
  }

  @Override
  public void onShowPhotoAlbum(File file) {
    IntentUtils.setNextActivity(this, PhotoAlbumActivity.class)
        .putExtra(Const.EXTRA_FILE_ID, file.getId())
        .startActivityForResult(Const.REQUEST_PHOTO_ALBUM);
  }

  @Override
  public void onUrlClicked(String url) {
    boolean handle = false;
    List<ChannelPluginListener> listeners = ChannelIO.getChannelPluginListeners();

    if (listeners.isEmpty()) {
      IntentUtils.setUrl(this, url).startActivity();
    } else {
      for (ChannelPluginListener listener : listeners) {
        handle = listener.onClickChatLink(url);
        if (!handle) {
          IntentUtils.setUrl(this, url).startActivity();
        }
      }
    }
  }

  private void onClickLinkableMessage(String linkText, LinkType linkType) {
    switch (linkType) {
      case URL:
        onUrlClicked(linkText);
        break;

      case PHONE:
        IntentUtils.setPhone(this, linkText).startActivity();
        break;

      case EMAIL:
        IntentUtils.setEmail(this, linkText).startActivity();
        break;
    }
  }

  @Override
  public void onChangeProfileMessageFocus(boolean hasFocus) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
      layoutInput.setBackground(ContextCompat.getDrawable(this,
          hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg));
    } else {
      layoutInput.setBackgroundDrawable(ContextCompat.getDrawable(this,
          hasFocus ? R.drawable.ch_plugin_chat_disabled_input_box_bg : R.drawable.ch_plugin_chat_input_box_bg));
    }
  }

  @Override
  public void onBackPressed() {
    if (!UserChatSelector.isEmpty() || (presenter != null && presenter.getUserChat() != null)) {
      finish();
    } else {
      goToMain();
    }
  }

  private void goToMain() {
    exit = true;

    setResult(Const.RESULT_CHAT_GO_TO_MAIN);
    finish();
  }

  @Override
  public void requestFocusEditText() {
    editChat.requestFocus();
  }

  @Override
  public void sendingMessageClicked(final SendingMessageItem item) {
    final AlertDialog dialog = new AlertDialog.Builder(this)
        .setMessage(ResUtils.getString(this, "ch.chat.resend.description"))
        .setPositiveButton(ResUtils.getString(this, "ch.chat.retry_sending_message"), new DialogInterface.OnClickListener() {
          @Override
          public void onClick(DialogInterface dialog, int which) {
            presenter.resend(item);
          }
        })
        .setNegativeButton(ResUtils.getString(this, "ch.chat.resend.cancel"), null)
        .setNeutralButton(ResUtils.getString(this, "ch.chat.delete"), new DialogInterface.OnClickListener() {
          @Override
          public void onClick(DialogInterface dialog, int which) {
            presenter.removeFailedItem(item);
          }
        })
        .setCancelable(true)
        .create();

    dialog.setOnShowListener(new DialogInterface.OnShowListener() {
      @Override
      public void onShow(DialogInterface args) {
        int dark = ContextCompat.getColor(ChatActivity.this, R.color.ch_dark);
        int cobalt = ContextCompat.getColor(ChatActivity.this, R.color.ch_cobalt);

        dialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(cobalt);
        dialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(dark);
        dialog.getButton(AlertDialog.BUTTON_NEUTRAL).setTextColor(dark);
      }
    });
    dialog.show();
  }

  @Override
  @AnimRes
  protected int getExistAnimOfFinish() {
    if (UserChatSelector.isEmpty() || exit) {
      return R.anim.ch_plugin_slide_out_bottom;
    }
    return R.anim.ch_plugin_slide_out_right;
  }
}