/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.zoyi.channel.plugin.android.R;

public class DownloadProgressBar
extends View {
    private float strokeWidth = 4.0f;
    private float progress = 0.0f;
    private int min = 0;
    private int max = 100;
    private int startAngle = -90;
    private int color = 0;
    private RectF rectF;
    private Paint backgroundPaint;
    private Paint foregroundPaint;

    public DownloadProgressBar(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.rectF = new RectF();
        context = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.DownloadProgressBar, 0, 0);
        try {
            this.strokeWidth = context.getDimension(R.styleable.DownloadProgressBar_ch_progressBarThickness, this.strokeWidth);
            this.progress = context.getFloat(R.styleable.DownloadProgressBar_ch_progress, this.progress);
            this.color = context.getInt(R.styleable.DownloadProgressBar_ch_progressbarColor, this.color);
            this.min = context.getInt(R.styleable.DownloadProgressBar_ch_min, this.min);
            this.max = context.getInt(R.styleable.DownloadProgressBar_ch_max, this.max);
        }
        finally {
            context.recycle();
        }
        this.backgroundPaint = new Paint(1);
        this.backgroundPaint.setColor(this.adjustAlpha(this.color, 0.3f));
        this.backgroundPaint.setStyle(Paint.Style.STROKE);
        this.backgroundPaint.setStrokeWidth(this.strokeWidth);
        this.foregroundPaint = new Paint(1);
        this.foregroundPaint.setColor(this.color);
        this.foregroundPaint.setStyle(Paint.Style.STROKE);
        this.foregroundPaint.setStrokeWidth(this.strokeWidth);
    }

    private int adjustAlpha(int n2, float f2) {
        int n3 = Math.round((float)Color.alpha((int)n2) * f2);
        int n4 = Color.red((int)n2);
        int n5 = Color.green((int)n2);
        n2 = Color.blue((int)n2);
        return Color.argb((int)n3, (int)n4, (int)n5, (int)n2);
    }

    protected void onMeasure(int n2, int n3) {
        n3 = DownloadProgressBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)n3);
        n2 = DownloadProgressBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n2 = Math.min(n2, n3);
        this.setMeasuredDimension(n2, n2);
        this.rectF.set(0.0f + this.strokeWidth / 2.0f, 0.0f + this.strokeWidth / 2.0f, (float)n2 - this.strokeWidth / 2.0f, (float)n2 - this.strokeWidth / 2.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float f2 = 360.0f * this.progress / (float)this.max;
        canvas.drawArc(this.rectF, (float)this.startAngle, f2, false, this.foregroundPaint);
    }

    public void setProgress(float f2) {
        this.progress = f2;
        this.invalidate();
    }
}

