/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.external.nineoldandroids.view.animation;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class AnimatorProxy
extends Animation {
    public static final boolean NEEDS_PROXY = Integer.valueOf(Build.VERSION.SDK) < 11;
    private static final WeakHashMap<View, AnimatorProxy> PROXIES = new WeakHashMap();
    private final WeakReference<View> mView;
    private final Camera mCamera = new Camera();
    private boolean mHasPivot;
    private float mAlpha = 1.0f;
    private float mPivotX;
    private float mPivotY;
    private float mRotationX;
    private float mRotationY;
    private float mRotationZ;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mTranslationX;
    private float mTranslationY;
    private final RectF mBefore = new RectF();
    private final RectF mAfter = new RectF();
    private final Matrix mTempMatrix = new Matrix();

    public static AnimatorProxy wrap(View view) {
        AnimatorProxy animatorProxy = PROXIES.get(view);
        if (animatorProxy == null || animatorProxy != view.getAnimation()) {
            animatorProxy = new AnimatorProxy(view);
            PROXIES.put(view, animatorProxy);
        }
        return animatorProxy;
    }

    private AnimatorProxy(View view) {
        this.setDuration(0L);
        this.setFillAfter(true);
        view.setAnimation((Animation)this);
        this.mView = new WeakReference<View>(view);
    }

    public final float getAlpha() {
        return this.mAlpha;
    }

    public final void setAlpha(float f2) {
        if (this.mAlpha != f2) {
            this.mAlpha = f2;
            View view = (View)this.mView.get();
            if (view != null) {
                view.invalidate();
            }
        }
    }

    public final float getPivotX() {
        return this.mPivotX;
    }

    public final void setPivotX(float f2) {
        if (!this.mHasPivot || this.mPivotX != f2) {
            this.prepareForUpdate();
            this.mHasPivot = true;
            this.mPivotX = f2;
            this.invalidateAfterUpdate();
        }
    }

    public final float getPivotY() {
        return this.mPivotY;
    }

    public final void setPivotY(float f2) {
        if (!this.mHasPivot || this.mPivotY != f2) {
            this.prepareForUpdate();
            this.mHasPivot = true;
            this.mPivotY = f2;
            this.invalidateAfterUpdate();
        }
    }

    public final float getRotation() {
        return this.mRotationZ;
    }

    public final void setRotation(float f2) {
        if (this.mRotationZ != f2) {
            this.prepareForUpdate();
            this.mRotationZ = f2;
            this.invalidateAfterUpdate();
        }
    }

    public final float getRotationX() {
        return this.mRotationX;
    }

    public final void setRotationX(float f2) {
        if (this.mRotationX != f2) {
            this.prepareForUpdate();
            this.mRotationX = f2;
            this.invalidateAfterUpdate();
        }
    }

    public final float getRotationY() {
        return this.mRotationY;
    }

    public final void setRotationY(float f2) {
        if (this.mRotationY != f2) {
            this.prepareForUpdate();
            this.mRotationY = f2;
            this.invalidateAfterUpdate();
        }
    }

    public final float getScaleX() {
        return this.mScaleX;
    }

    public final void setScaleX(float f2) {
        if (this.mScaleX != f2) {
            this.prepareForUpdate();
            this.mScaleX = f2;
            this.invalidateAfterUpdate();
        }
    }

    public final float getScaleY() {
        return this.mScaleY;
    }

    public final void setScaleY(float f2) {
        if (this.mScaleY != f2) {
            this.prepareForUpdate();
            this.mScaleY = f2;
            this.invalidateAfterUpdate();
        }
    }

    public final int getScrollX() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0;
        }
        return view.getScrollX();
    }

    public final void setScrollX(int n2) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.scrollTo(n2, view.getScrollY());
        }
    }

    public final int getScrollY() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0;
        }
        return view.getScrollY();
    }

    public final void setScrollY(int n2) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.scrollTo(view.getScrollX(), n2);
        }
    }

    public final float getTranslationX() {
        return this.mTranslationX;
    }

    public final void setTranslationX(float f2) {
        if (this.mTranslationX != f2) {
            this.prepareForUpdate();
            this.mTranslationX = f2;
            this.invalidateAfterUpdate();
        }
    }

    public final float getTranslationY() {
        return this.mTranslationY;
    }

    public final void setTranslationY(float f2) {
        if (this.mTranslationY != f2) {
            this.prepareForUpdate();
            this.mTranslationY = f2;
            this.invalidateAfterUpdate();
        }
    }

    public final float getX() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0.0f;
        }
        return (float)view.getLeft() + this.mTranslationX;
    }

    public final void setX(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            this.setTranslationX(f2 - (float)view.getLeft());
        }
    }

    public final float getY() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0.0f;
        }
        return (float)view.getTop() + this.mTranslationY;
    }

    public final void setY(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            this.setTranslationY(f2 - (float)view.getTop());
        }
    }

    private void prepareForUpdate() {
        View view = (View)this.mView.get();
        if (view != null) {
            this.computeRect(this.mBefore, view);
        }
    }

    private void invalidateAfterUpdate() {
        View view = (View)this.mView.get();
        if (view == null || view.getParent() == null) {
            return;
        }
        RectF rectF = this.mAfter;
        this.computeRect(rectF, view);
        rectF.union(this.mBefore);
        ((View)view.getParent()).invalidate((int)Math.floor(rectF.left), (int)Math.floor(rectF.top), (int)Math.ceil(rectF.right), (int)Math.ceil(rectF.bottom));
    }

    private void computeRect(RectF rectF, View view) {
        float f2 = view.getWidth();
        float f3 = view.getHeight();
        rectF.set(0.0f, 0.0f, f2, f3);
        Matrix matrix = this.mTempMatrix;
        matrix.reset();
        this.transformMatrix(matrix, view);
        this.mTempMatrix.mapRect(rectF);
        rectF.offset((float)view.getLeft(), (float)view.getTop());
        if (rectF.right < rectF.left) {
            float f4 = rectF.right;
            rectF.right = rectF.left;
            rectF.left = f4;
        }
        if (rectF.bottom < rectF.top) {
            float f5 = rectF.top;
            rectF.top = rectF.bottom;
            rectF.bottom = f5;
        }
    }

    private void transformMatrix(Matrix matrix, View view) {
        float f2 = view.getWidth();
        float f3 = view.getHeight();
        boolean bl = this.mHasPivot;
        float f4 = bl ? this.mPivotX : f2 / 2.0f;
        float f5 = bl ? this.mPivotY : f3 / 2.0f;
        float f6 = this.mRotationX;
        float f7 = this.mRotationY;
        float f8 = this.mRotationZ;
        if (f6 != 0.0f || f7 != 0.0f || f8 != 0.0f) {
            Camera camera = this.mCamera;
            camera.save();
            camera.rotateX(f6);
            camera.rotateY(f7);
            camera.rotateZ(-f8);
            camera.getMatrix(matrix);
            camera.restore();
            matrix.preTranslate(-f4, -f5);
            matrix.postTranslate(f4, f5);
        }
        float f9 = this.mScaleX;
        f6 = this.mScaleY;
        if (f9 != 1.0f || f6 != 1.0f) {
            matrix.postScale(f9, f6);
            f2 = -(f4 / f2) * (f9 * f2 - f2);
            f3 = -(f5 / f3) * (f6 * f3 - f3);
            matrix.postTranslate(f2, f3);
        }
        matrix.postTranslate(this.mTranslationX, this.mTranslationY);
    }

    protected final void applyTransformation(float f2, Transformation transformation) {
        View view = (View)this.mView.get();
        if (view != null) {
            transformation.setAlpha(this.mAlpha);
            this.transformMatrix(transformation.getMatrix(), view);
        }
    }
}

