/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.app.Application;
import android.content.Context;
import android.location.Location;
import com.a.a.e;
import com.splunk.mint.ActionError;
import com.splunk.mint.ActionEvent;
import com.splunk.mint.ActionTransactionStart;
import com.splunk.mint.ActionTransactionStop;
import com.splunk.mint.ActionView;
import com.splunk.mint.ActivityLifecycleCallbacksManager;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.CrashInfo;
import com.splunk.mint.DataSaver;
import com.splunk.mint.ExceptionHandler;
import com.splunk.mint.ExtraData;
import com.splunk.mint.ForegroundHandler;
import com.splunk.mint.InstrumentationEnvironment;
import com.splunk.mint.InstrumentationEnvironmentUtils;
import com.splunk.mint.LastPing;
import com.splunk.mint.Logger;
import com.splunk.mint.MemoryTrimHandler;
import com.splunk.mint.Mint$1;
import com.splunk.mint.Mint$2;
import com.splunk.mint.Mint$3;
import com.splunk.mint.MintCallback;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.Properties;
import com.splunk.mint.Properties$RemoteSettingsProps;
import com.splunk.mint.SequentialExecutor;
import com.splunk.mint.TimerManager;
import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.NetLogManager;
import com.splunk.mint.network.http.MonitorableURLStreamHandlerFactory;
import com.splunk.mint.network.socket.MonitoringSocketFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import org.json.JSONObject;

public final class Mint {
    static boolean DEBUG = false;
    static boolean netInitializedSuccessfully = false;
    static boolean triedToInitNet = false;
    private static MonitorRegistry registry = new MonitorRegistry();
    private static boolean isSessionActive = false;
    private static boolean networkMonitoringEnabled = true;
    private static boolean crashMonitoringEnabled = true;
    static MintCallback mintCallback = null;
    public static final String appEnvironmentRelease = "Release";
    public static final String appEnvironmentStaging = "Staging";
    public static final String appEnvironmentUserAcceptanceTesting = "UserAcceptanceTesting";
    public static final String appEnvironmentTesting = "Testing";
    public static final String appEnvironmentDevelopment = "Development";
    private static boolean memoryPressureMonitoringEnabled = true;
    public static final String XSplunkMintSessionIdHeader = "X-Splunk-Mint-Session-id";
    public static final String XSplunkMintUuidHeader = "X-Splunk-Mint-uuid";
    private static final SequentialExecutor executor = new SequentialExecutor();

    public static void initAndStartSession(Application application, String string) {
        Properties.hecEnabled = false;
        Mint.initAndStartSession(application, string, null, null);
    }

    public static void initAndStartSessionHEC(Application application, String string, String string2) {
        Properties.hecEnabled = true;
        Mint.initAndStartSession(application, "NA", string, string2);
    }

    private static synchronized void initAndStartSession(Application application, String string, String string2, String string3) {
        if (application == null) {
            Logger.logWarning("Application is null!");
            return;
        }
        if (Properties.hecEnabled) {
            Mint.doUrlChecksForHEC(string2, string3);
            Properties.hecToken = string3;
        } else {
            Mint.doUrlChecksForCDS(string);
        }
        Properties.TIMESTAMP = System.currentTimeMillis();
        Mint.logFeatureStates();
        ForegroundHandler.initialize(application);
        Mint.installExceptionHandler();
        Mint.installMemoryPressureHandler(application);
        Mint.installActivityLifecycleHandler(application);
        if (!netInitializedSuccessfully) {
            Mint.initializeNetworkMonitoring();
        }
        ActionEvent actionEvent = ActionEvent.createPing();
        executor.getExecutor().execute(new Mint$1(application, string2, string3, string, actionEvent));
    }

    private static void logFeatureStates() {
        Mint.logFeatureState("Crash Monitoring", crashMonitoringEnabled);
        Mint.logFeatureState("Network Monitoring", networkMonitoringEnabled);
    }

    private static void doUrlChecksForHEC(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Your Mint HEC URL is null!");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Your Mint HEC Token is null!");
        }
        if (string.length() < 10) {
            throw new IllegalArgumentException("Your Mint HEC URL is invalid!");
        }
        if (string2.length() < 10) {
            throw new IllegalArgumentException("Your Mint HEC Token is invalid!");
        }
        if (!string.toLowerCase().startsWith("http")) {
            throw new IllegalArgumentException("Your Mint HEC URL is invalid!");
        }
    }

    private static void doUrlChecksForCDS(String string) {
        if (string == null || string.length() < 8 || string.length() > 14) {
            throw new IllegalArgumentException("Your Mint API Key is invalid!");
        }
        Properties.API_KEY = string;
    }

    private static synchronized void initializeNetworkMonitoring() {
        if (networkMonitoringEnabled) {
            if (!Mint.networkMonitoredByBuildtimeInstrumentation()) {
                if (!triedToInitNet && NetLogManager.deviceSupporsNetworkMonitoring() && Properties$RemoteSettingsProps.netMonitoringEnabled.booleanValue()) {
                    Logger.logInfo("Initializing Network Monitoring");
                    triedToInitNet = true;
                    try {
                        URL.setURLStreamHandlerFactory(new MonitorableURLStreamHandlerFactory(Mint.getRegistry()));
                    }
                    catch (Throwable throwable) {
                        netInitializedSuccessfully = false;
                    }
                    try {
                        MonitoringSocketFactory monitoringSocketFactory = new MonitoringSocketFactory(registry);
                        Socket.setSocketImplFactory(monitoringSocketFactory);
                        SSLSocket.setSocketImplFactory(monitoringSocketFactory);
                        netInitializedSuccessfully = true;
                    }
                    catch (Throwable throwable) {
                        netInitializedSuccessfully = false;
                    }
                    if (netInitializedSuccessfully) {
                        Logger.logInfo("Network monitoring was initialized successfully!");
                        return;
                    }
                }
            } else {
                netInitializedSuccessfully = true;
            }
        }
    }

    static void disableInstrumentationNetworkMonitoring() {
        InstrumentationEnvironment instrumentationEnvironment = InstrumentationEnvironmentUtils.getInstance();
        if (instrumentationEnvironment == null) {
            return;
        }
        instrumentationEnvironment.disableNetworkMonitoring();
    }

    static boolean networkMonitoredByBuildtimeInstrumentation() {
        InstrumentationEnvironment instrumentationEnvironment = InstrumentationEnvironmentUtils.getInstance();
        if (instrumentationEnvironment == null) {
            return false;
        }
        boolean bl = instrumentationEnvironment.isAppliedAtBuildtime();
        if (bl) {
            Logger.logInfo("Network monitoring is applied at build time");
        }
        return bl;
    }

    private static MonitorRegistry getRegistry() {
        if (registry == null) {
            registry = new MonitorRegistry();
        }
        return registry;
    }

    public static synchronized void startSession(Application application) {
        if (Properties.isPluginInitialized()) {
            ActionEvent actionEvent = ActionEvent.createPing();
            Mint.startSession(actionEvent, application);
        }
    }

    private static synchronized void startSession(ActionEvent actionEvent, Application application) {
        if (application == null) {
            Logger.logWarning("Application is null!");
            return;
        }
        if (!isSessionActive) {
            isSessionActive = true;
            Properties.initialize((Context)application, null, null, null);
        }
        executor.getExecutor().submit(new Mint$2(application, actionEvent));
    }

    public static synchronized void closeSession(Application application) {
        if (Properties.isPluginInitialized() && isSessionActive) {
            isSessionActive = false;
            ActionEvent actionEvent = ActionEvent.createGnip((Context)application);
            actionEvent.save();
            LastPing.clearLastPingSentTime((Context)application);
        }
    }

    public static void flush() {
        if (Properties.isPluginInitialized()) {
            DataSaver.flush();
        }
    }

    public static final void startANRMonitoring(int n2, boolean bl) {
        if (n2 > 5000) {
            Logger.logWarning("Timeout should be less or equal to 5000");
        }
        Mint.logFeatureState("ANR Monitoring", true);
        new e(n2).a(new Mint$3()).a(bl).start();
    }

    private static void logFeatureState(String string, boolean bl) {
        Logger.logInfo(string + " enabled = " + bl);
    }

    public static void setSessionInterval(int n2) {
        if (n2 < 30 || n2 > 86400) {
            Properties$RemoteSettingsProps.sessionTime = 60;
            Logger.logError("time for session interval should be more than 30 seconds and less than a day, setting default to 60 seconds");
            return;
        }
        Properties$RemoteSettingsProps.sessionTime = n2;
    }

    public static void setUserOptOut(boolean bl) {
        Properties.USER_OPTEDOUT = bl;
    }

    public static void disableNetworkMonitoring() {
        networkMonitoringEnabled = false;
        Mint.disableInstrumentationNetworkMonitoring();
    }

    public static void disableCrashMonitoring() {
        crashMonitoringEnabled = false;
    }

    public static final void setMintCallback(MintCallback mintCallback) {
        Mint.mintCallback = mintCallback;
    }

    public static void leaveBreadcrumb(String string) {
        if (Properties.isPluginInitialized() && string != null) {
            Properties.breadcrumbs.addToList(string);
        }
    }

    public static void logView(String string) {
        if (Properties.isPluginInitialized() && string != null) {
            ActionView.logView(string, null);
        }
    }

    public static void logView(String string, String string2, String string3) {
        if (Properties.isPluginInitialized() && string != null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put(string2, string3);
            ActionView.logView(string, hashMap);
        }
    }

    public static void logView(String string, HashMap<String, Object> hashMap) {
        if (Properties.isPluginInitialized() && string != null) {
            ActionView.logView(string, hashMap);
        }
    }

    public static void logEvent(String object) {
        if (Properties.isPluginInitialized() && object != null) {
            object = ActionEvent.createEvent((String)object);
            ((ActionEvent)object).save();
        }
    }

    public static void logEvent(String object, MintLogLevel mintLogLevel) {
        if (Properties.isPluginInitialized() && object != null) {
            object = ActionEvent.createEvent((String)object, mintLogLevel, null);
            ((ActionEvent)object).save();
        }
    }

    public static void logEvent(String object, MintLogLevel mintLogLevel, HashMap<String, Object> hashMap) {
        if (Properties.isPluginInitialized() && object != null) {
            object = ActionEvent.createEvent((String)object, mintLogLevel, hashMap);
            ((ActionEvent)object).save();
        }
    }

    public static void logEvent(String string, MintLogLevel mintLogLevel, String string2, String string3) {
        if (Properties.isPluginInitialized()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put(string2, string3);
            Mint.logEvent(string, mintLogLevel, hashMap);
        }
    }

    public static void setUserIdentifier(String string) {
        Properties.userIdentifier = string;
    }

    public static void setApplicationEnvironment(String string) {
        if (string != null && string.length() > 0) {
            Properties.applicationEnvironment = string;
        }
    }

    public static void enableDebugLog() {
        DEBUG = true;
    }

    public static void setFlushOnlyOverWiFi(boolean bl) {
        Properties.flushOnlyOverWiFi = bl;
    }

    public static String transactionStart(String object) {
        String string = null;
        if (Properties.isPluginInitialized() && object != null && ((String)object).length() > 0) {
            object = ActionTransactionStart.createTransactionStart((String)object, null);
            ((ActionTransactionStart)object).save();
            string = ((ActionTransactionStart)object).transaction_id;
        }
        return string;
    }

    public static String transactionStart(String object, HashMap<String, Object> hashMap) {
        String string = null;
        if (Properties.isPluginInitialized() && object != null && ((String)object).length() > 0) {
            object = ActionTransactionStart.createTransactionStart((String)object, hashMap);
            ((ActionTransactionStart)object).save();
            string = ((ActionTransactionStart)object).transaction_id;
        }
        return string;
    }

    public static String transactionStart(String string, String string2, String string3) {
        Object object = null;
        if (Properties.isPluginInitialized()) {
            object = new HashMap<String, Object>(1);
            ((HashMap)object).put(string2, string3);
            object = Mint.transactionStart(string, object);
        }
        return object;
    }

    public static void transactionStop(String object) {
        if (Properties.isPluginInitialized() && object != null && ((String)object).length() > 0) {
            if ((object = ActionTransactionStop.createTransactionStop((String)object, null)) == null) {
                return;
            }
            ((ActionTransactionStop)object).save();
        }
    }

    public static void transactionStop(String object, HashMap<String, Object> hashMap) {
        if (Properties.isPluginInitialized() && object != null && ((String)object).length() > 0) {
            if ((object = ActionTransactionStop.createTransactionStop((String)object, hashMap)) == null) {
                return;
            }
            ((ActionTransactionStop)object).save();
        }
    }

    public static void transactionStop(String string, String string2, String string3) {
        if (Properties.isPluginInitialized() && string != null && string.length() > 0) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put(string2, string3);
            Mint.transactionStop(string, hashMap);
        }
    }

    public static void transactionCancel(String object, String string) {
        if (Properties.isPluginInitialized() && object != null && ((String)object).length() > 0) {
            if ((object = ActionTransactionStop.createTransactionCancel((String)object, string, null)) == null) {
                return;
            }
            ((ActionTransactionStop)object).save();
        }
    }

    public static void transactionCancel(String object, String string, HashMap<String, Object> hashMap) {
        if (Properties.isPluginInitialized() && object != null && ((String)object).length() > 0) {
            if ((object = ActionTransactionStop.createTransactionCancel((String)object, string, hashMap)) == null) {
                return;
            }
            ((ActionTransactionStop)object).save();
        }
    }

    public static void transactionCancel(String string, String string2, String string3, String string4) {
        if (Properties.isPluginInitialized() && string != null && string.length() > 0) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
            hashMap.put(string3, string4);
            Mint.transactionCancel(string, string2, hashMap);
        }
    }

    public static String timerStart(String string) {
        String string2 = null;
        if (Properties.isPluginInitialized()) {
            string2 = TimerManager.getInstance().timerStart(string);
        }
        return string2;
    }

    public static void timerStop(String string) {
        if (Properties.isPluginInitialized() && string != null && string.length() > 0) {
            TimerManager.getInstance().timerStop(string);
        }
    }

    public static HashMap<String, Object> getExtraData() {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : Properties.extraData.getExtraData().entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    public static void addExtraData(String string, String string2) {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
        }
        if (string != null) {
            if (string2 == null) {
                string2 = "null";
            }
            Properties.extraData.addExtraData(string, string2);
        }
    }

    public static void removeExtraData(String string) {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
        }
        if (string != null) {
            Properties.extraData.removeKey(string);
        }
    }

    public static void clearExtraData() {
        if (Properties.extraData == null) {
            Properties.extraData = new ExtraData();
        }
        Properties.extraData.clearData();
    }

    public static int getTotalCrashesNum() {
        return new CrashInfo().getTotalCrashesNum();
    }

    public static void clearTotalCrashesNum() {
        if (Properties.isPluginInitialized()) {
            new CrashInfo().clearCrashCounter();
        }
    }

    public static String getLastCrashID() {
        return new CrashInfo().getLastCrashID();
    }

    public static void logException(HashMap<String, Object> object, Exception exception) {
        if (Properties.isPluginInitialized()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            object = new ActionError(0, ((Object)stringWriter).toString(), 0, (HashMap<String, Object>)object);
            ((ActionError)object).save();
        }
    }

    public static void logException(Exception exception) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(0);
        Mint.logException(hashMap, exception);
    }

    public static void logException(String string, String string2, Exception exception) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        if (string != null && string2 != null) {
            hashMap.put(string, string2);
        }
        Mint.logException(hashMap, exception);
    }

    public static void xamarinException(Exception exception, boolean bl, HashMap<String, Object> hashMap) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        byte by = 1;
        if (bl) {
            by = 0;
        }
        ActionError actionError = new ActionError(0, ((Object)stringWriter).toString().replaceFirst("\n", "\n\t"), by, hashMap);
        actionError.save();
    }

    public static void enableLogging(boolean bl) {
        Properties.SEND_LOG = bl;
    }

    public static void setLogging(int n2) {
        if (n2 > 0) {
            Properties.SEND_LOG = true;
            Properties.LOG_LINES = n2;
        }
    }

    public static void setLogging(String string) {
        if (string != null) {
            Properties.SEND_LOG = true;
            Properties.LOG_FILTER = string;
        }
    }

    public static void setLogging(int n2, String string) {
        if (string != null && n2 > 0) {
            Properties.SEND_LOG = true;
            Properties.LOG_LINES = n2;
            Properties.LOG_FILTER = string;
        }
    }

    public static JSONObject getDevSettings() {
        return Properties$RemoteSettingsProps.devSettings;
    }

    public static void addURLToBlackList(String string) {
        if (string != null) {
            Properties.excludedUrls.addValue(string);
        }
    }

    private static void installExceptionHandler() {
        if (!crashMonitoringEnabled) {
            return;
        }
        Logger.logInfo("Registering the exception handler");
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(uncaughtExceptionHandler instanceof ExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(uncaughtExceptionHandler));
        }
    }

    public static void disableMemoryPressureMonitoring() {
        memoryPressureMonitoringEnabled = false;
    }

    private static void installMemoryPressureHandler(Application application) {
        if (memoryPressureMonitoringEnabled) {
            MemoryTrimHandler.initialize(application);
        }
    }

    private static void installActivityLifecycleHandler(Application application) {
        ActivityLifecycleCallbacksManager.initialize(application);
    }

    public static final String getSessionId() {
        String string = BaseDTO.getGlobalSessionID();
        if (string != null && string.length() > 0) {
            return string;
        }
        return "NA";
    }

    public static final String getMintUUID() {
        if (Properties.UID != null || Properties.UID.length() > 0) {
            return Properties.UID;
        }
        return "NA";
    }

    public static void setLocation(Location location) {
        Properties.location = location;
    }

    static /* synthetic */ void access$000(ActionEvent actionEvent, Application application) {
        Mint.startSession(actionEvent, application);
    }
}

