/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import com.splunk.mint.DataSaver$1;
import com.splunk.mint.DataSaver$2;
import com.splunk.mint.DataSaver$3;
import com.splunk.mint.Logger;
import com.splunk.mint.Mint;
import com.splunk.mint.MintUrls;
import com.splunk.mint.NetSender;
import com.splunk.mint.NetSenderResponse;
import com.splunk.mint.Properties;
import com.splunk.mint.SequentialExecutor;
import com.splunk.mint.SplunkFileFilter;
import com.splunk.mint.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

class DataSaver {
    private static final int MAX_FILE_SIZE = 143360;
    private static final int MAX_FILES = 3;
    private static final SequentialExecutor executor = new SequentialExecutor();
    private static final String LAST_SAVED_NAME = "/Mint-lastsavedfile";

    private DataSaver() {
    }

    public static void flush() {
        executor.getExecutor().submit(new DataSaver$1());
    }

    private static void flushInternal() {
        if (!Utils.allowedToSendData()) {
            Logger.logInfo("You have enabled the FlushOnlyOverWiFi option and there is no WiFi connection, data will not be sent now.");
            return;
        }
        if (Properties.FILES_PATH != null && !Properties.USER_OPTEDOUT) {
            File[] fileArray = new File(Properties.FILES_PATH);
            if ((fileArray = fileArray.listFiles(SplunkFileFilter.getInstance())) != null) {
                for (File file : fileArray) {
                    String string;
                    NetSenderResponse netSenderResponse;
                    block8: {
                        netSenderResponse = new NetSenderResponse(MintUrls.getURL(), null);
                        if (!file.exists()) {
                            netSenderResponse.setException(new Exception("There is no data to be sent. This is not an error."));
                            netSenderResponse.setSentSuccessfully(false);
                            continue;
                        }
                        string = null;
                        try {
                            string = Utils.readFile(file.getAbsolutePath());
                        }
                        catch (Exception exception) {
                            netSenderResponse.setException(exception);
                            netSenderResponse.setSentSuccessfully(false);
                            exception.printStackTrace();
                            if (Mint.mintCallback == null) break block8;
                            Mint.mintCallback.netSenderResponse(netSenderResponse);
                        }
                    }
                    if (string == null || string.length() == 0) {
                        if (Mint.mintCallback == null) continue;
                        Mint.mintCallback.netSenderResponse(netSenderResponse);
                        continue;
                    }
                    NetSenderResponse netSenderResponse2 = NetSender.sendBlocking(null, string, false);
                    if (!netSenderResponse2.getSentSuccessfully().booleanValue()) continue;
                    file.delete();
                }
            }
        }
    }

    private static void deleteOldFiles() {
        File[] fileArray = new File(Properties.FILES_PATH);
        if ((fileArray = fileArray.listFiles(SplunkFileFilter.getInstance())) == null || fileArray.length <= 3) {
            return;
        }
        Arrays.sort(fileArray, new DataSaver$2());
        int n2 = fileArray.length - 3;
        for (int i2 = 0; i2 < n2; ++i2) {
            fileArray[i2].delete();
        }
    }

    public static void save(String string) {
        executor.getExecutor().submit(new DataSaver$3(string));
    }

    private static String getLastSavedName() {
        File file = new File(Properties.FILES_PATH + LAST_SAVED_NAME);
        try {
            return Utils.readFile(file.getAbsolutePath()).trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveLastSavedName(String object) {
        Object object2;
        File file = new File(Properties.FILES_PATH + LAST_SAVED_NAME);
        if (!file.exists()) {
            try {
                file.delete();
                file.createNewFile();
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
        }
        object2 = null;
        object2 = new BufferedWriter(new FileWriter(file));
        ((Writer)object2).write(((String)object).trim());
        ((BufferedWriter)object2).flush();
        ((BufferedWriter)object2).close();
        try {
            ((BufferedWriter)object2).close();
            return;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            try {
                Logger.logWarning("There was a problem saving the last saved file name");
                if (Mint.DEBUG) {
                    iOException.printStackTrace();
                }
                if (object2 == null) return;
            }
            catch (Throwable throwable) {
                if (object2 == null) throw throwable;
                try {
                    ((BufferedWriter)object2).close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    IOException iOException3 = iOException2;
                    iOException2.printStackTrace();
                }
                throw throwable;
            }
            try {
                ((BufferedWriter)object2).close();
                return;
            }
            catch (IOException iOException4) {
                IOException iOException5 = iOException4;
                iOException4.printStackTrace();
                return;
            }
        }
    }

    static /* synthetic */ void access$000() {
        DataSaver.flushInternal();
    }

    static /* synthetic */ String access$100() {
        return DataSaver.getLastSavedName();
    }

    static /* synthetic */ void access$200() {
        DataSaver.deleteOldFiles();
    }

    static /* synthetic */ void access$300(String string) {
        DataSaver.saveLastSavedName(string);
    }
}

