/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.global;

import android.content.Context;
import com.zoyi.channel.plugin.android.CheckIn;
import java.util.Map;

public class CheckInPrefSupervisor {
    private static final String CHECK_IN_PREF = "CheckInPreferences";
    private static final String HAS_CHECK_IN_DATA = "hasCheckInData";
    private static final String USER_ID = "userId";
    private static final String NAME = "name";
    private static final String AVATAR_URL = "avatarUrl";
    private static final String MOBILE_NUMBER = "mobileNumber";

    public static void set(Context context, CheckIn iterator) {
        context = context.getSharedPreferences(CHECK_IN_PREF, 0);
        context = context.edit();
        context.putBoolean(HAS_CHECK_IN_DATA, true);
        if (iterator != null) {
            context.putString(USER_ID, ((CheckIn)((Object)iterator)).getUserId());
            context.putString(NAME, ((CheckIn)((Object)iterator)).getName());
            context.putString(AVATAR_URL, ((CheckIn)((Object)iterator)).getAvatarUrl());
            context.putString(MOBILE_NUMBER, ((CheckIn)((Object)iterator)).getMobileNumber());
            iterator = ((CheckIn)((Object)iterator)).getMapMeta();
            for (Map.Entry<String, Object> entry : iterator.entrySet()) {
                Object object = entry.getValue();
                if (object == null) continue;
                if (object instanceof String) {
                    context.putString(entry.getKey(), String.valueOf(object));
                    continue;
                }
                if (object instanceof Integer) {
                    context.putInt(entry.getKey(), ((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Long) {
                    context.putLong(entry.getKey(), ((Long)object).longValue());
                    continue;
                }
                if (!(object instanceof Boolean)) continue;
                context.putBoolean(entry.getKey(), ((Boolean)object).booleanValue());
            }
        }
        context.apply();
    }

    public static CheckIn get(Context object) {
        object = object.getSharedPreferences(CHECK_IN_PREF, 0);
        CheckIn checkIn = new CheckIn();
        object = object.getAll();
        for (Map.Entry entry : object.entrySet()) {
            if (USER_ID.equals(entry.getKey())) {
                checkIn.withUserId(String.valueOf(entry.getValue()));
                continue;
            }
            if (NAME.equals(entry.getKey())) {
                checkIn.withName(String.valueOf(entry.getValue()));
                continue;
            }
            if (AVATAR_URL.equals(entry.getKey())) {
                checkIn.withAvatarUrl(String.valueOf(entry.getValue()));
                continue;
            }
            if (MOBILE_NUMBER.equals(entry.getKey())) {
                checkIn.withMobileNumber(String.valueOf(entry.getValue()));
                continue;
            }
            Object v2 = entry.getValue();
            if (v2 instanceof String) {
                checkIn.withMeta((String)entry.getKey(), String.valueOf(v2));
                continue;
            }
            if (v2 instanceof Integer) {
                checkIn.withMeta((String)entry.getKey(), (Integer)v2);
                continue;
            }
            if (v2 instanceof Long) {
                checkIn.withMeta((String)entry.getKey(), (Long)v2);
                continue;
            }
            if (!(v2 instanceof Boolean) || ((String)entry.getKey()).equals(HAS_CHECK_IN_DATA)) continue;
            checkIn.withMeta((String)entry.getKey(), (Boolean)v2);
        }
        return checkIn;
    }

    public static boolean hasCheckInData(Context context) {
        context = context.getSharedPreferences(CHECK_IN_PREF, 0);
        return context.getBoolean(HAS_CHECK_IN_DATA, false);
    }

    public static void clear(Context context) {
        context = context.getSharedPreferences(CHECK_IN_PREF, 0);
        context = context.edit();
        context.clear();
        context.apply();
    }
}

