/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.http;

import com.splunk.mint.Properties;
import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.NetLogManager;
import com.splunk.mint.network.Timer;
import com.splunk.mint.network.io.InputStreamMonitor;
import com.splunk.mint.network.io.InputStreamMonitorKitKat;
import com.splunk.mint.network.io.OutputStreamMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.List;
import java.util.Map;

public final class MonitorableHttpURLConnection
extends HttpURLConnection {
    private URLConnection original;
    private final MonitorRegistry registry;
    private final Timer timer;
    private final String connectionName;
    private InputStreamMonitor mInputStreamMonitor = null;
    private OutputStreamMonitor mOutputStreamMonitor = null;
    private InputStreamMonitorKitKat mInputStreamMonitorKitKat = null;

    public MonitorableHttpURLConnection(MonitorRegistry monitorRegistry, URLConnection uRLConnection) {
        super(uRLConnection.getURL());
        this.registry = monitorRegistry;
        this.original = uRLConnection;
        this.connectionName = this.url.toString();
        this.timer = new Timer(this.connectionName);
        NetLogManager.getInstance().startNetworkCall(uRLConnection.getURL().toExternalForm(), uRLConnection.getURL().toExternalForm(), System.currentTimeMillis(), "HTTP");
    }

    @Override
    public final void connect() throws IOException {
        try {
            this.timer.start();
            this.original.connect();
            return;
        }
        catch (IOException iOException) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public final void disconnect() {
        int n2 = NetLogManager.getStatusCodeFromURLConnection(this.original);
        NetLogManager.getInstance().endNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), n2);
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).disconnect();
        }
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        try {
            if (Properties.isKitKat) {
                if (this.mInputStreamMonitorKitKat == null) {
                    this.mInputStreamMonitorKitKat = new InputStreamMonitorKitKat(this.original.getURL().toString() + "-in", this.registry, this.original.getInputStream(), null);
                }
                return this.mInputStreamMonitorKitKat;
            }
            if (this.mInputStreamMonitor == null) {
                this.mInputStreamMonitor = new InputStreamMonitor(this.original.getURL().toString() + "-in", this.registry, this.original.getInputStream(), null);
            }
            return this.mInputStreamMonitor;
        }
        catch (IOException iOException) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        try {
            if (this.mOutputStreamMonitor == null) {
                this.mOutputStreamMonitor = new OutputStreamMonitor(this.original.getURL().toString() + "-out", this.registry, this.original.getOutputStream());
            }
            return this.mOutputStreamMonitor;
        }
        catch (IOException iOException) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public final boolean getAllowUserInteraction() {
        return this.original.getAllowUserInteraction();
    }

    @Override
    public final void addRequestProperty(String string, String string2) {
        this.original.addRequestProperty(string, string2);
    }

    @Override
    public final int getConnectTimeout() {
        return this.original.getConnectTimeout();
    }

    @Override
    public final Object getContent() throws IOException {
        try {
            return this.original.getContent();
        }
        catch (IOException iOException) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", iOException.getMessage());
            throw iOException;
        }
    }

    public final Object getContent(Class[] classArray) throws IOException {
        try {
            return this.original.getContent(classArray);
        }
        catch (IOException iOException) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public final String getContentEncoding() {
        return this.original.getContentEncoding();
    }

    @Override
    public final int getContentLength() {
        return this.original.getContentLength();
    }

    @Override
    public final String getContentType() {
        return this.original.getContentType();
    }

    @Override
    public final long getDate() {
        return this.original.getDate();
    }

    @Override
    public final boolean getDefaultUseCaches() {
        return this.original.getDefaultUseCaches();
    }

    @Override
    public final boolean getDoInput() {
        return this.original.getDoInput();
    }

    @Override
    public final boolean getDoOutput() {
        return this.original.getDoOutput();
    }

    @Override
    public final long getExpiration() {
        return this.original.getExpiration();
    }

    @Override
    public final String getHeaderField(int n2) {
        return this.original.getHeaderField(n2);
    }

    @Override
    public final String getHeaderField(String string) {
        return this.original.getHeaderField(string);
    }

    @Override
    public final long getHeaderFieldDate(String string, long l2) {
        return this.original.getHeaderFieldDate(string, l2);
    }

    @Override
    public final int getHeaderFieldInt(String string, int n2) {
        return this.original.getHeaderFieldInt(string, n2);
    }

    @Override
    public final String getHeaderFieldKey(int n2) {
        return this.original.getHeaderFieldKey(n2);
    }

    @Override
    public final Map<String, List<String>> getHeaderFields() {
        return this.original.getHeaderFields();
    }

    @Override
    public final long getIfModifiedSince() {
        return this.original.getIfModifiedSince();
    }

    @Override
    public final long getLastModified() {
        return this.original.getLastModified();
    }

    @Override
    public final Permission getPermission() throws IOException {
        try {
            return this.original.getPermission();
        }
        catch (IOException iOException) {
            NetLogManager.getInstance().cancelNetworkCall(this.registry, this.url.toExternalForm(), System.currentTimeMillis(), "HTTP", iOException.getMessage());
            throw iOException;
        }
    }

    @Override
    public final int getReadTimeout() {
        return this.original.getReadTimeout();
    }

    @Override
    public final Map<String, List<String>> getRequestProperties() {
        return this.original.getRequestProperties();
    }

    @Override
    public final String getRequestProperty(String string) {
        return this.original.getRequestProperty(string);
    }

    @Override
    public final URL getURL() {
        return this.original.getURL();
    }

    @Override
    public final boolean getUseCaches() {
        return this.original.getUseCaches();
    }

    @Override
    public final void setAllowUserInteraction(boolean bl) {
        this.original.setAllowUserInteraction(bl);
    }

    @Override
    public final void setConnectTimeout(int n2) {
        this.original.setConnectTimeout(n2);
    }

    @Override
    public final void setDefaultUseCaches(boolean bl) {
        this.original.setDefaultUseCaches(bl);
    }

    @Override
    public final void setDoInput(boolean bl) {
        this.original.setDoInput(bl);
    }

    @Override
    public final void setDoOutput(boolean bl) {
        this.original.setDoOutput(bl);
    }

    @Override
    public final void setIfModifiedSince(long l2) {
        this.original.setIfModifiedSince(l2);
    }

    @Override
    public final void setReadTimeout(int n2) {
        this.original.setReadTimeout(n2);
    }

    @Override
    public final void setRequestProperty(String string, String string2) {
        this.original.setRequestProperty(string, string2);
    }

    @Override
    public final void setUseCaches(boolean bl) {
        this.original.setUseCaches(bl);
    }

    @Override
    public final boolean usingProxy() {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).usingProxy();
        }
        return false;
    }

    @Override
    public final InputStream getErrorStream() {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getErrorStream();
        }
        return null;
    }

    @Override
    public final boolean getInstanceFollowRedirects() {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getInstanceFollowRedirects();
        }
        return true;
    }

    @Override
    public final String getRequestMethod() {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getRequestMethod();
        }
        return "GET";
    }

    @Override
    public final int getResponseCode() throws IOException {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getResponseCode();
        }
        return -1;
    }

    @Override
    public final String getResponseMessage() throws IOException {
        if (this.original instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.original).getResponseMessage();
        }
        return "";
    }

    @Override
    public final void setChunkedStreamingMode(int n2) {
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).setChunkedStreamingMode(n2);
        }
    }

    @Override
    public final void setFixedLengthStreamingMode(int n2) {
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).setFixedLengthStreamingMode(n2);
        }
    }

    @Override
    public final void setInstanceFollowRedirects(boolean bl) {
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).setInstanceFollowRedirects(bl);
        }
    }

    @Override
    public final void setRequestMethod(String string) throws ProtocolException {
        if (this.original instanceof HttpURLConnection) {
            ((HttpURLConnection)this.original).setRequestMethod(string);
        }
    }
}

