/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.retrofit2.adapter.rxjava;

import com.zoyi.retrofit2.Call;
import com.zoyi.retrofit2.Response;
import com.zoyi.retrofit2.adapter.rxjava.CallArbiter;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;

final class CallExecuteOnSubscribe<T>
implements Observable.OnSubscribe<Response<T>> {
    private final Call<T> originalCall;

    CallExecuteOnSubscribe(Call<T> originalCall) {
        this.originalCall = originalCall;
    }

    public void call(Subscriber<? super Response<T>> subscriber) {
        Response response;
        Call call = this.originalCall.clone();
        CallArbiter arbiter = new CallArbiter(call, subscriber);
        subscriber.add(arbiter);
        subscriber.setProducer(arbiter);
        try {
            response = call.execute();
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal((Throwable)t);
            arbiter.emitError(t);
            return;
        }
        arbiter.emitResponse(response);
    }
}

