/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat;

import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.event.TypingBus;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import com.zoyi.rx.subscriptions.CompositeSubscription;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TypingManager
implements TextWatcher {
    private static final int TYPING_THROTTLE = 1000;
    private String chatId;
    private String chatType;
    private long typingStartTime = 0L;
    private Map<String, Subscription> typingSubscriptionItems;
    private CompositeSubscription ttlSubscriptions;

    public TypingManager(String chatId, String chatType, WatchedEditText editText) {
        this.chatId = chatId;
        this.chatType = chatType;
        editText.addTextChangedListener(this);
        this.typingSubscriptionItems = new HashMap<String, Subscription>();
        this.ttlSubscriptions = new CompositeSubscription();
    }

    public void release() {
        if (this.ttlSubscriptions != null && !this.ttlSubscriptions.isUnsubscribed()) {
            this.ttlSubscriptions.unsubscribe();
        }
        this.typingSubscriptionItems.clear();
        this.stopTyping();
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        String msg = s.toString();
        if (TextUtils.isEmpty((CharSequence)msg)) {
            this.stopTyping();
        } else if (this.typingStartTime == 0L) {
            this.startTyping();
        } else if (System.currentTimeMillis() - this.typingStartTime > 1000L) {
            this.startTyping();
        }
    }

    public void afterTextChanged(Editable s) {
    }

    public void startTyping() {
        this.typingStartTime = System.currentTimeMillis();
        SocketManager.typing(new Typing("start", this.chatId, this.chatType));
    }

    public void stopTyping() {
        this.typingStartTime = 0L;
        SocketManager.typing(new Typing("stop", this.chatId, this.chatType));
    }

    public void addTTLTimer(Typing typing) {
        Subscription subscription = this.typingSubscriptionItems.get(typing.getKey());
        if (subscription != null) {
            this.removeTTLSubscription(typing);
        }
        switch (typing.getAction()) {
            case "start": {
                this.addTTLSubscription(typing);
            }
        }
    }

    private void removeTTLSubscription(Typing typing) {
        Subscription subscription = this.typingSubscriptionItems.remove(typing.getKey());
        if (subscription != null) {
            this.ttlSubscriptions.remove(subscription);
        }
    }

    private void addTTLSubscription(final Typing typing) {
        Subscription subscription = Observable.timer((long)30L, (TimeUnit)TimeUnit.SECONDS, (Scheduler)Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Long aLong) {
                if (typing != null && typing.isExpired()) {
                    typing.setAction("stop");
                    RxBus.post(new TypingBus(typing));
                }
            }
        });
        this.typingSubscriptionItems.put(typing.getKey(), subscription);
        this.ttlSubscriptions.add(subscription);
    }
}

