package com.zoyi.channel.plugin.android.activity.chat;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

public class PreviewFragment extends Fragment implements View.OnClickListener {

  private View root;
  private AvatarLayout avatarPreview;
  private TextView textPerson, textPreviewMessage;

  @Nullable
  @Override
  public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
    return inflater.inflate(R.layout.ch_plugin_fragment_chat_preview, container, false);
  }

  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);

    root = view;
    root.setOnClickListener(this);

    avatarPreview = (AvatarLayout) view.findViewById(R.id.layout_avatar_preview);
    textPerson = (TextView) view.findViewById(R.id.text_preview_person);
    textPreviewMessage = (TextView) view.findViewById(R.id.text_preview_message);
  }

  @Override
  public void onClick(View v) {
    if (getActivity() instanceof ChatActivity) {
      hide();
      ((ChatActivity) getActivity()).scrollToBottom(true);
    }
  }

  public void show(Manager manager, Message message) {
    avatarPreview.set(manager);
    textPerson.setText(TextUtils.isEmpty(manager.getName()) ? getString(R.string.ch_unknown) : manager.getName());

    File file = message.getFile();
    if (file != null) {
      if (file.isImage()) {
        textPreviewMessage.setText(R.string.ch_chat_preview_image_message);
      } else {
        textPreviewMessage.setText(R.string.ch_chat_preview_file_message);
      }
    } else {
      textPreviewMessage.setText(TextUtils.isEmpty(message.getMessage()) ? getString(R.string.ch_unknown) : message.getMessage());
    }
    root.setVisibility(View.VISIBLE);
  }

  public void hide() {
    root.setVisibility(View.GONE);
  }
}
