package com.zoyi.channel.plugin.android.activity.settings;

import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.ChannelLayout;

public class SettingsHeaderFragment extends Fragment implements View.OnClickListener {

  private ChannelLayout layoutChannelImage;
  private TextView textChannelName, textChannelPhoneNumber;

  @Nullable
  @Override
  public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
    return inflater.inflate(R.layout.ch_plugin_fragment_settings_header, container, false);
  }

  @Override
  public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    super.onViewCreated(view, savedInstanceState);

    Channel channel = ChannelStore.getChannel();
    Plugin plugin = ChannelStore.getPlugin();

    if (channel != null && plugin != null) {
      layoutChannelImage = (ChannelLayout) view.findViewById(R.id.layout_channel_image);
      textChannelName = (TextView) view.findViewById(R.id.tv_channel_name);
      textChannelPhoneNumber = (TextView) view.findViewById(R.id.tv_channel_phone_number);

      view.setBackgroundColor(Color.parseColor(plugin.getBorderColor()));
      setChannelImage(channel, plugin);

      textChannelName.setText(channel.getName());
      textChannelName.setTextColor(plugin.getTextColor());

      textChannelPhoneNumber.setText(channel.getPhoneNumber());
      textChannelPhoneNumber.setOnClickListener(this);
      textChannelPhoneNumber.setVisibility(
          UIUtils.getVisible(!TextUtils.isEmpty(channel.getPhoneNumber()), true));

      setChannelNameMargin();
    }
  }

  private void setChannelNameMargin() {
    LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) textChannelName.getLayoutParams();

    if (textChannelPhoneNumber.getVisibility() == View.VISIBLE) {
      params.bottomMargin = (int) Utils.dpToPx(getContext(), 6);
    } else {
      params.bottomMargin = (int) Utils.dpToPx(getContext(), 24);
    }
    textChannelName.setLayoutParams(params);
  }

  private void setChannelImage(Channel channel, Plugin plugin) {
    if (TextUtils.isEmpty(channel.getAvatarUrl())) {
      layoutChannelImage.set(channel, plugin);
    } else {
      layoutChannelImage.set(channel);
    }
  }

  @Override
  public void onClick(View v) {
    int id = v.getId();
    if (id == R.id.tv_channel_phone_number) {
      Executor.call(getContext(), textChannelPhoneNumber.getText().toString());
    }
  }
}
