/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.content.Context;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.model.rest.ChannelModel;
import com.zoyi.channel.plugin.android.model.rest.UpdatedModel;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;

public class UserChat
implements ChannelModel,
UpdatedModel {
    private String id;
    private String channelId;
    private String personType;
    private String personId;
    private String referId;
    private String state;
    private Long createdAt;
    private Long updatedAt;
    private Long followedAt;
    private Long resolvedAt;
    private String lastMessageId;
    private String openedAt;
    private Long notifiedAt;
    private Boolean alert;
    private Boolean unread;
    private List<String> talkedManagerIds;
    private String review;
    private String followedBy;
    private Long resolutionTime;
    public static final String CLASSNAME = "UserChat";

    @Override
    public String getId() {
        return this.id;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getPersonType() {
        return this.personType;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getReferId() {
        return this.referId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public boolean isStateResolved() {
        return !TextUtils.isEmpty((CharSequence)this.state) && "resolved".equals(this.state);
    }

    public boolean isStateClosed() {
        return !TextUtils.isEmpty((CharSequence)this.state) && "closed".equals(this.state);
    }

    public boolean isStateCompleted() {
        return !TextUtils.isEmpty((CharSequence)this.state) && "resolved&closed".contains(this.state);
    }

    public boolean isStateRemoved() {
        return !TextUtils.isEmpty((CharSequence)this.state) && "removed".equals(this.state);
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getLastMessageId() {
        return this.lastMessageId;
    }

    public String getOpenedAt() {
        return this.openedAt;
    }

    public Long getNotifiedAt() {
        return this.notifiedAt;
    }

    public Boolean getAlert() {
        return this.alert;
    }

    public Boolean getUnread() {
        return this.unread;
    }

    public List<String> getTalkedManagerIds() {
        if (this.talkedManagerIds == null) {
            return new ArrayList<String>();
        }
        return this.talkedManagerIds;
    }

    public String getReview() {
        return this.review;
    }

    public Long getFollowedAt() {
        return this.followedAt;
    }

    public Long getResolvedAt() {
        return this.resolvedAt;
    }

    public String getFollowedBy() {
        return this.followedBy;
    }

    public Long getResolutionTime() {
        return this.resolutionTime;
    }

    public String getResolutionDuration(Context context) {
        return TimeUtils.getResolveDuration(context, this.resolutionTime);
    }

    public String getSessionId() {
        return String.format("%s:%s", this.channelId, this.id);
    }
}

