/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Application;
import android.content.Context;
import com.splunk.mint.Mint;
import com.zoyi.b.d.av;
import com.zoyi.channel.plugin.android.ActivityLifecycleManager;
import com.zoyi.channel.plugin.android.ChannelException;
import com.zoyi.channel.plugin.android.ChannelException$StatusCode;
import com.zoyi.channel.plugin.android.ChannelStore;
import com.zoyi.channel.plugin.android.CheckIn;
import com.zoyi.channel.plugin.android.OnChannelPluginChangedListener;
import com.zoyi.channel.plugin.android.OnCheckInListener;
import com.zoyi.channel.plugin.android.a;
import com.zoyi.channel.plugin.android.activity.chat.ChatManager;
import com.zoyi.channel.plugin.android.activity.userchat_list.UserChatListActivity;
import com.zoyi.channel.plugin.android.b;
import com.zoyi.channel.plugin.android.c;
import com.zoyi.channel.plugin.android.enumerate.Command;
import com.zoyi.channel.plugin.android.event.CommandBus;
import com.zoyi.channel.plugin.android.event.RxBus;
import com.zoyi.channel.plugin.android.global.CheckInPrefSupervisor;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ChannelPlugin {
    private static final String MINT_DEBUG_KEY = "e72f17f4";
    private static final String MINT_PROD_KEY = "22464da6";
    private static boolean isDebugMode = false;
    private static ChannelPlugin channelPlugin;
    private static ChannelApi channelApi;
    private Application application;
    private String pluginId;
    private Thread.UncaughtExceptionHandler mUncaughtExceptionHandler;
    private AtomicInteger checkInCounter = new AtomicInteger(0);

    public static void initialize(Application application, String string2) {
        ChannelPlugin.initialize(application, string2, false);
    }

    public static void initialize(Application application, String string2, boolean bl) {
        if (channelPlugin != null) {
            L.i("Channel plugin already initialized");
            return;
        }
        if (application == null) {
            L.e("Application cannot be null");
            return;
        }
        if (string2 == null) {
            L.e("Plugin key cannot be null");
            return;
        }
        isDebugMode = bl;
        channelPlugin = new ChannelPlugin(application, string2);
    }

    private ChannelPlugin(Application application, String string2) {
        this.application = application;
        this.pluginId = string2;
        ChannelStore.create(application, string2);
        SocketManager.create(application);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleManager());
        this.mUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new a(this));
    }

    public static void checkIn() {
        ChannelPlugin.checkIn(null, null);
    }

    public static void checkIn(OnCheckInListener onCheckInListener) {
        ChannelPlugin.checkIn(null, onCheckInListener);
    }

    public static void checkIn(CheckIn checkIn) {
        ChannelPlugin.checkIn(checkIn, null);
    }

    public static void checkIn(CheckIn checkIn, OnCheckInListener onCheckInListener) {
        if (ChannelPlugin.isInitialized()) {
            if (!ChannelPlugin.isDataStored()) {
                channelPlugin.checkVersion(checkIn, onCheckInListener);
                return;
            }
            if (onCheckInListener != null) {
                onCheckInListener.onFailed(new ChannelException(ChannelException$StatusCode.ALREADY_CHECKED_IN, "Already checked in. Please check out and try again."));
                return;
            }
        } else if (onCheckInListener != null) {
            onCheckInListener.onFailed(new ChannelException(ChannelException$StatusCode.NOT_INITIALIZED, "Please initialize first"));
        }
    }

    private void checkVersion(CheckIn checkIn, OnCheckInListener onCheckInListener) {
        int n2 = this.checkInCounter.incrementAndGet();
        ChannelPlugin.getApi().getLastestPackage("com.zoyi.channel.plugin.android", "0.0.5").b(Schedulers.newThread()).a(com.zoyi.rx.a.b.a.a()).b(new b(this, n2, onCheckInListener, checkIn));
    }

    private void checkInProcess(CheckIn checkIn, OnCheckInListener onCheckInListener, int n2) {
        Object object = new HashMap<String, Object>();
        if (checkIn != null) {
            object.put((String)"name", (Object)checkIn.getName());
            object.put("mobileNumber", checkIn.getMobileNumber());
            object.put("avatarUrl", checkIn.getAvatarUrl());
            object.put("meta", checkIn.getMeta());
        }
        object = RequestUtils.form(object).create();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (checkIn != null && checkIn.getUserId() != null) {
            hashMap.put("X-User-Id", checkIn.getUserId());
        }
        if (PrefSupervisor.getVeilId((Context)this.application) != null) {
            hashMap.put("X-Veil-Id", PrefSupervisor.getVeilId((Context)this.application));
        }
        ChannelPlugin.getApi().checkIn(hashMap, this.pluginId, null, (av)object).b(Schedulers.newThread()).a(com.zoyi.rx.a.b.a.a()).b(new c(this, n2, onCheckInListener, checkIn));
    }

    public static void checkOut() {
        if (ChannelPlugin.isInitialized()) {
            channelPlugin.checkOutProcess();
        }
    }

    private void checkOutProcess() {
        this.checkInCounter.incrementAndGet();
        ChannelStore.clear();
        CheckInPrefSupervisor.clear((Context)this.application);
        ChannelPushManager.deleteToken((Context)this.application);
        RxBus.post(new CommandBus(Command.CHECKED_OUT));
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        ChatManager.release();
        this.releaseBugTracking();
    }

    public static boolean launch(Context context) {
        if (!ChannelPlugin.isInitialized() || !ChannelPlugin.isDataStored() || context == null) {
            L.e("Please check in first");
            return false;
        }
        IntentUtils.setNextActivity(context, UserChatListActivity.class).startActivity();
        return true;
    }

    public static ChannelApi getApi() {
        if (channelApi == null) {
            channelApi = ServiceFactory.create();
        }
        return channelApi;
    }

    private void initBugTracking() {
        if (this.application != null) {
            Mint.disableNetworkMonitoring();
            Mint.initAndStartSession(this.application, isDebugMode ? MINT_DEBUG_KEY : MINT_PROD_KEY);
            Mint.addExtraData("plugin_version", "0.0.5");
        }
    }

    private void releaseBugTracking() {
        if (this.application != null) {
            Mint.clearExtraData();
            Mint.closeSession(this.application);
            Mint.flush();
        }
    }

    public static boolean isInitialized() {
        if (channelPlugin == null) {
            L.e("Please initialize first");
            return false;
        }
        return true;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    public static boolean isDataStored() {
        return ChannelStore.isDataStored();
    }

    public static void addOnChannelPluginChangedListener(OnChannelPluginChangedListener onChannelPluginChangedListener) {
        ChannelStore.addOnChannelPluginChangedListener(onChannelPluginChangedListener);
    }

    public static void removeOnChannelPluginChangedListener(OnChannelPluginChangedListener onChannelPluginChangedListener) {
        ChannelStore.removeOnChannelPluginChangedListener(onChannelPluginChangedListener);
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler access$000(ChannelPlugin channelPlugin) {
        return channelPlugin.mUncaughtExceptionHandler;
    }

    static /* synthetic */ AtomicInteger access$100(ChannelPlugin channelPlugin) {
        return channelPlugin.checkInCounter;
    }

    static /* synthetic */ void access$200(ChannelPlugin channelPlugin, CheckIn checkIn, OnCheckInListener onCheckInListener, int n2) {
        channelPlugin.checkInProcess(checkIn, onCheckInListener, n2);
    }

    static /* synthetic */ void access$300(ChannelPlugin channelPlugin) {
        channelPlugin.initBugTracking();
    }

    static /* synthetic */ Application access$400(ChannelPlugin channelPlugin) {
        return channelPlugin.application;
    }
}

