/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.annotation.SuppressLint;
import android.app.Application;
import android.location.Location;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.splunk.mint.ActionView;
import com.splunk.mint.Mint;
import com.splunk.mint.MintJavascript$1;
import com.splunk.mint.MintLogLevel;
import com.splunk.mint.SequentialExecutor;
import com.splunk.mint.network.NetLogManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONObject;

public class MintJavascript {
    private static final SequentialExecutor executor = new SequentialExecutor();
    private Application app;
    private WebView webview;
    private HashMap<String, Object> jExtraData = new HashMap(1);

    @SuppressLint(value={"NewApi"})
    public static String loadMintJavascript() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:");
        MintJavascript.loadJavaScript(stringBuilder, "tracekit.js");
        MintJavascript.loadJavaScript(stringBuilder, "mint.js");
        return stringBuilder.toString();
    }

    private static void loadJavaScript(StringBuilder stringBuilder, String object) {
        try {
            String string;
            object = MintJavascript.class.getResourceAsStream((String)object);
            object = new BufferedReader(new InputStreamReader((InputStream)object));
            while ((string = ((BufferedReader)object).readLine()) != null) {
                stringBuilder.append(string);
            }
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    public MintJavascript(Application application, WebView webView) {
        this.app = application;
        this.webview = webView;
        this.jExtraData.put("webview", true);
    }

    @JavascriptInterface
    public void javascriptError(String string, String string2, String string3, String string4, String string5) {
        executor.getExecutor().submit(new MintJavascript$1(this, string5, string, string2, string3, string4));
    }

    @JavascriptInterface
    public void logNetwork(String string, String string2, String string3, String string4, String string5) {
        NetLogManager.getInstance().logNetworkRequest(string2, string, System.currentTimeMillis() - Long.valueOf(string3), System.currentTimeMillis(), Integer.valueOf(string4), 0L, Long.valueOf(string5), "", this.jExtraData);
    }

    @JavascriptInterface
    public void initAndStartSession(String string) {
        Mint.initAndStartSession(this.app, string);
    }

    @JavascriptInterface
    public void initAndStartSessionHEC(String string, String string2) {
        Mint.initAndStartSessionHEC(this.app, string, string2);
    }

    @JavascriptInterface
    public void addExtraData(String string, String string2) {
        Mint.addExtraData(string, string2);
    }

    @JavascriptInterface
    public void clearExtraData() {
        Mint.clearExtraData();
    }

    @JavascriptInterface
    public void closeSession() {
        Mint.closeSession(this.app);
    }

    @JavascriptInterface
    public void flush() {
        Mint.flush();
    }

    @JavascriptInterface
    public void leaveBreadcrumb(String string) {
        Mint.leaveBreadcrumb(string);
    }

    @JavascriptInterface
    public void logEvent(String string, String object) {
        object = MintJavascript.JsonStringToExtraData((String)object);
        ((HashMap)object).putAll(this.jExtraData);
        Mint.logEvent(string, MintLogLevel.Info, (HashMap<String, Object>)object);
    }

    @JavascriptInterface
    public void removeExtraData(String string) {
        Mint.removeExtraData(string);
    }

    @JavascriptInterface
    public void setLogging(int n2, String string) {
        Mint.setLogging(n2, string);
    }

    @JavascriptInterface
    public void setUserIdentifier(String string) {
        Mint.setUserIdentifier(string);
    }

    @JavascriptInterface
    public void setApplicationEnvironment(String string) {
        Mint.setApplicationEnvironment(string);
    }

    @JavascriptInterface
    public void setLocation(double d2, double d3, long l2) {
        Location location = new Location("");
        location.setLatitude(d2);
        location.setLongitude(d3);
        location.setTime(l2);
        Mint.setLocation(location);
    }

    @JavascriptInterface
    public void startSession() {
        Mint.startSession(this.app);
    }

    @JavascriptInterface
    public String transactionStart(String string, String object) {
        object = MintJavascript.JsonStringToExtraData((String)object);
        ((HashMap)object).putAll(this.jExtraData);
        return Mint.transactionStart(string, (HashMap<String, Object>)object);
    }

    @JavascriptInterface
    public void transactionStop(String string, String object) {
        object = MintJavascript.JsonStringToExtraData((String)object);
        ((HashMap)object).putAll(this.jExtraData);
        Mint.transactionStop(string, (HashMap<String, Object>)object);
    }

    @JavascriptInterface
    public void transactionCancel(String string, String string2, String object) {
        object = MintJavascript.JsonStringToExtraData((String)object);
        ((HashMap)object).putAll(this.jExtraData);
        Mint.transactionCancel(string, string2, (HashMap<String, Object>)object);
    }

    @JavascriptInterface
    public void logView(String string, String object, String object2, String object3, String object4, String string2, String string3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("webview", true);
        hashMap.putAll(MintJavascript.JsonStringToExtraData(string3));
        object = object == null ? null : Integer.valueOf((String)object);
        object2 = object2 == null ? null : Integer.valueOf((String)object2);
        object3 = object3 == null ? null : Integer.valueOf((String)object3);
        object4 = object4 == null ? null : Integer.valueOf((String)object4);
        ActionView.logView(string, (Integer)object2, (Integer)object4, (Integer)object3, string2, (Integer)object, hashMap);
    }

    @JavascriptInterface
    public String timerStart(String string) {
        return Mint.timerStart(string);
    }

    @JavascriptInterface
    public void timerStop(String string) {
        Mint.timerStop(string);
    }

    private static synchronized HashMap<String, Object> JsonStringToExtraData(String object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        if (object == null || ((String)object).length() <= 4 || ((String)object).equals("undefined")) {
            return hashMap;
        }
        try {
            object = new JSONObject((String)object);
            Iterator iterator = object.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object2 = object.get(string);
                hashMap.put(string, object2);
            }
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return hashMap;
    }

    static /* synthetic */ HashMap access$000(MintJavascript mintJavascript) {
        return mintJavascript.jExtraData;
    }
}

