/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import com.splunk.mint.DataSaverResponse;
import com.splunk.mint.Logger;
import com.splunk.mint.Mint;
import com.splunk.mint.MintUrls;
import com.splunk.mint.NetSender;
import com.splunk.mint.NetSenderResponse;
import com.splunk.mint.Properties;
import com.splunk.mint.SequentialExecutor;
import com.splunk.mint.SplunkFileFilter;
import com.splunk.mint.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

class DataSaver {
    private static final int MAX_FILE_SIZE = 143360;
    private static final int MAX_FILES = 3;
    private static final SequentialExecutor executor = new SequentialExecutor();
    private static final String LAST_SAVED_NAME = "/Mint-lastsavedfile";

    private DataSaver() {
    }

    public static void flush() {
        executor.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                DataSaver.flushInternal();
            }
        });
    }

    private static void flushInternal() {
        File filesPath;
        File[] files;
        if (!Utils.allowedToSendData()) {
            Logger.logInfo("You have enabled the FlushOnlyOverWiFi option and there is no WiFi connection, data will not be sent now.");
        } else if (Properties.FILES_PATH != null && !Properties.USER_OPTEDOUT && (files = (filesPath = new File(Properties.FILES_PATH)).listFiles(SplunkFileFilter.getInstance())) != null) {
            for (File file : files) {
                String jsonData;
                NetSenderResponse nsr;
                block8: {
                    nsr = new NetSenderResponse(MintUrls.getURL(), null);
                    if (!file.exists()) {
                        nsr.setException(new Exception("There is no data to be sent. This is not an error."));
                        nsr.setSentSuccessfully(false);
                        continue;
                    }
                    jsonData = null;
                    try {
                        jsonData = Utils.readFile(file.getAbsolutePath());
                    }
                    catch (Exception e) {
                        nsr.setException(e);
                        nsr.setSentSuccessfully(false);
                        e.printStackTrace();
                        if (Mint.mintCallback == null) break block8;
                        Mint.mintCallback.netSenderResponse(nsr);
                    }
                }
                if (jsonData == null || jsonData.length() == 0) {
                    if (Mint.mintCallback == null) continue;
                    Mint.mintCallback.netSenderResponse(nsr);
                    continue;
                }
                NetSenderResponse sendResult = NetSender.sendBlocking(null, jsonData, false);
                if (!sendResult.getSentSuccessfully().booleanValue()) continue;
                file.delete();
            }
        }
    }

    private static void deleteOldFiles() {
        File path = new File(Properties.FILES_PATH);
        File[] files = path.listFiles(SplunkFileFilter.getInstance());
        if (files == null || files.length <= 3) {
            return;
        }
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                Long modifiedTimeF1 = f1.lastModified();
                Long modifiedTimeF2 = f2.lastModified();
                return modifiedTimeF1.compareTo(modifiedTimeF2);
            }
        });
        int numberOfFilesToDelete = files.length - 3;
        for (int i = 0; i < numberOfFilesToDelete; ++i) {
            files[i].delete();
        }
    }

    public static void save(final String jsonData) {
        executor.getExecutor().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!Properties.USER_OPTEDOUT) {
                    File file = null;
                    String lastName = DataSaver.getLastSavedName();
                    file = lastName == null || lastName.length() == 0 ? new File(SplunkFileFilter.createNewFile()) : new File(Properties.FILES_PATH + "/" + lastName);
                    boolean flushData = false;
                    if (file.length() >= 143360L) {
                        file = new File(SplunkFileFilter.createNewFile());
                        flushData = true;
                    }
                    try {
                        if (!file.exists()) {
                            file.createNewFile();
                            DataSaver.deleteOldFiles();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    DataSaverResponse dsr = new DataSaverResponse(jsonData, file.getAbsolutePath());
                    BufferedWriter bWritter = null;
                    try {
                        bWritter = new BufferedWriter(new FileWriter(file, true));
                        bWritter.append(jsonData);
                        bWritter.flush();
                        bWritter.close();
                        DataSaver.saveLastSavedName(file.getName());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        dsr.setException(e);
                        dsr.setSavedSuccessfully(false);
                        if (Mint.mintCallback != null) {
                            Mint.mintCallback.dataSaverResponse(dsr);
                        }
                    }
                    finally {
                        if (bWritter != null) {
                            try {
                                bWritter.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        dsr.setSavedSuccessfully(true);
                        if (Mint.mintCallback != null) {
                            Mint.mintCallback.dataSaverResponse(dsr);
                        }
                        if (flushData) {
                            DataSaver.flush();
                        }
                    }
                }
            }
        });
    }

    private static String getLastSavedName() {
        File file = new File(Properties.FILES_PATH + LAST_SAVED_NAME);
        try {
            return Utils.readFile(file.getAbsolutePath()).trim();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveLastSavedName(String name) {
        File file = new File(Properties.FILES_PATH + LAST_SAVED_NAME);
        if (file != null && !file.exists()) {
            try {
                file.delete();
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BufferedWriter bos = null;
        try {
            bos = new BufferedWriter(new FileWriter(file));
            bos.write(name.trim());
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            Logger.logWarning("There was a problem saving the last saved file name");
            if (Mint.DEBUG) {
                e.printStackTrace();
            }
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

