package com.zoyi.channel.plugin.android.util;

import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;

public class TextDecorator {

  public static SpannableString bold(String text, String target) {
    return bold(new SpannableString(text), target);
  }

  public static SpannableString bold(SpannableString string, String target) {
    int start = string.toString().indexOf(target);
    int end = start+target.length();

    string.setSpan(new StyleSpan(Typeface.BOLD), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);

    return string;
  }

  public static SpannableString size(String text, String target, int size) {
    return size(new SpannableString(text), target, size);
  }

  public static SpannableString size(SpannableString string, String target, int size) {
    int start = string.toString().indexOf(target);
    int end = start+target.length();

    string.setSpan(new AbsoluteSizeSpan(size), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);

    return string;
  }

  public static SpannableString color(String text, String target, @ColorInt int color) {
    return color(new SpannableString(text), target, color);
  }

  public static SpannableString color(SpannableString string, String target, @ColorInt int color) {
    int start = string.toString().indexOf(target);
    int end = start+target.length();

    string.setSpan(new ForegroundColorSpan(color), start, end, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);

    return string;
  }
}
