/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subjects;

import com.zoyi.rx.Observable$OnSubscribe;
import com.zoyi.rx.Observer;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.exceptions.OnErrorThrowable;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.internal.util.atomic.SpscLinkedAtomicQueue;
import com.zoyi.rx.internal.util.atomic.SpscUnboundedAtomicArrayQueue;
import com.zoyi.rx.internal.util.unsafe.SpscLinkedQueue;
import com.zoyi.rx.internal.util.unsafe.SpscUnboundedArrayQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import java.io.Serializable;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class UnicastSubject$State<T>
extends AtomicLong
implements Observable$OnSubscribe<T>,
Observer<T>,
Producer,
Subscription {
    private static final long serialVersionUID = -9044104859202255786L;
    final AtomicReference<Subscriber<? super T>> subscriber;
    final Queue<Object> queue;
    final NotificationLite<T> nl = NotificationLite.instance();
    final AtomicReference<Action0> terminateOnce;
    Throwable error;
    volatile boolean done;
    boolean emitting;
    boolean missed;
    volatile boolean caughtUp;

    public UnicastSubject$State(int n2, Action0 action0) {
        this.subscriber = new AtomicReference();
        AtomicReference<Action0> atomicReference = this.terminateOnce = action0 != null ? new AtomicReference<Action0>(action0) : null;
        Queue<Object> queue = n2 > 1 ? (UnsafeAccess.isUnsafeAvailable() ? new SpscUnboundedArrayQueue(n2) : new SpscUnboundedAtomicArrayQueue(n2)) : (UnsafeAccess.isUnsafeAvailable() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue());
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onNext(T t2) {
        if (!this.done) {
            Serializable serializable;
            if (!this.caughtUp) {
                boolean bl = false;
                serializable = this;
                synchronized (serializable) {
                    if (!this.caughtUp) {
                        this.queue.offer(this.nl.next(t2));
                        bl = true;
                    }
                }
                if (bl) {
                    this.replay();
                    return;
                }
            }
            Subscriber<T> subscriber = this.subscriber.get();
            try {
                subscriber.onNext(t2);
                return;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                Exceptions.throwOrReport(throwable, subscriber, t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onError(Throwable throwable) {
        if (!this.done) {
            this.doTerminate();
            this.error = throwable;
            this.done = true;
            if (!this.caughtUp) {
                boolean bl;
                UnicastSubject$State unicastSubject$State = this;
                synchronized (unicastSubject$State) {
                    bl = !this.caughtUp;
                }
                if (bl) {
                    this.replay();
                    return;
                }
            }
            this.subscriber.get().onError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onCompleted() {
        if (!this.done) {
            this.doTerminate();
            this.done = true;
            if (!this.caughtUp) {
                boolean bl;
                UnicastSubject$State unicastSubject$State = this;
                synchronized (unicastSubject$State) {
                    bl = !this.caughtUp;
                }
                if (bl) {
                    this.replay();
                    return;
                }
            }
            this.subscriber.get().onCompleted();
        }
    }

    @Override
    public final void request(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (l2 > 0L) {
            BackpressureUtils.getAndAddRequest(this, l2);
            this.replay();
            return;
        }
        if (this.done) {
            this.replay();
        }
    }

    @Override
    public final void call(Subscriber<? super T> subscriber) {
        if (this.subscriber.compareAndSet(null, subscriber)) {
            subscriber.add(this);
            subscriber.setProducer(this);
            return;
        }
        subscriber.onError(new IllegalStateException("Only a single subscriber is allowed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void replay() {
        Object object = this;
        synchronized (object) {
            if (this.emitting) {
                this.missed = true;
                return;
            }
            this.emitting = true;
        }
        object = this.queue;
        while (true) {
            Subscriber<T> subscriber = this.subscriber.get();
            boolean bl = false;
            if (subscriber != null) {
                boolean bl2 = this.done;
                boolean bl3 = object.isEmpty();
                if (this.checkTerminated(bl2, bl3, subscriber)) {
                    return;
                }
                long l2 = this.get();
                bl = l2 == Long.MAX_VALUE;
                long l3 = 0L;
                while (l2 != 0L) {
                    bl2 = this.done;
                    Object e2 = object.poll();
                    boolean bl4 = bl3 = e2 == null;
                    if (this.checkTerminated(bl2, bl3, subscriber)) {
                        return;
                    }
                    if (bl3) break;
                    T t2 = this.nl.getValue(e2);
                    try {
                        subscriber.onNext(t2);
                    }
                    catch (Throwable throwable) {
                        object.clear();
                        Exceptions.throwIfFatal(throwable);
                        subscriber.onError(OnErrorThrowable.addValueAsLastCause(throwable, t2));
                        return;
                    }
                    --l2;
                    ++l3;
                }
                if (!bl && l3 != 0L) {
                    this.addAndGet(-l3);
                }
            }
            UnicastSubject$State unicastSubject$State = this;
            synchronized (unicastSubject$State) {
                if (!this.missed) {
                    if (bl && object.isEmpty()) {
                        this.caughtUp = true;
                    }
                    this.emitting = false;
                    return;
                }
                this.missed = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unsubscribe() {
        this.doTerminate();
        this.done = true;
        UnicastSubject$State unicastSubject$State = this;
        synchronized (unicastSubject$State) {
            if (this.emitting) {
                return;
            }
            this.emitting = true;
        }
        this.queue.clear();
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.done;
    }

    final boolean checkTerminated(boolean bl, boolean bl2, Subscriber<? super T> subscriber) {
        if (subscriber.isUnsubscribed()) {
            this.queue.clear();
            return true;
        }
        if (bl) {
            Throwable throwable = this.error;
            if (throwable != null) {
                this.queue.clear();
                subscriber.onError(throwable);
                return true;
            }
            if (bl2) {
                subscriber.onCompleted();
                return true;
            }
        }
        return false;
    }

    final void doTerminate() {
        Action0 action0;
        AtomicReference<Action0> atomicReference = this.terminateOnce;
        if (atomicReference != null && (action0 = atomicReference.get()) != null && atomicReference.compareAndSet(action0, null)) {
            action0.call();
        }
    }
}

