/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subjects;

import com.zoyi.rx.Scheduler;
import com.zoyi.rx.annotations.Beta;
import com.zoyi.rx.schedulers.Schedulers;
import com.zoyi.rx.subjects.ReplaySubject$ReplayProducer;
import com.zoyi.rx.subjects.ReplaySubject$ReplaySizeAndTimeBoundBuffer;
import com.zoyi.rx.subjects.ReplaySubject$ReplaySizeBoundBuffer;
import com.zoyi.rx.subjects.ReplaySubject$ReplayState;
import com.zoyi.rx.subjects.ReplaySubject$ReplayUnboundedBuffer;
import com.zoyi.rx.subjects.Subject;
import java.util.concurrent.TimeUnit;

public final class ReplaySubject<T>
extends Subject<T, T> {
    final ReplaySubject$ReplayState<T> state;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static <T> ReplaySubject<T> create() {
        return ReplaySubject.create(16);
    }

    public static <T> ReplaySubject<T> create(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("capacity > 0 required but it was " + n2);
        }
        Object object = new ReplaySubject$ReplayUnboundedBuffer(n2);
        object = new ReplaySubject$ReplayState(object);
        return new ReplaySubject<T>(object);
    }

    static <T> ReplaySubject<T> createUnbounded() {
        Object object = new ReplaySubject$ReplaySizeBoundBuffer(Integer.MAX_VALUE);
        object = new ReplaySubject$ReplayState(object);
        return new ReplaySubject<T>(object);
    }

    static <T> ReplaySubject<T> createUnboundedTime() {
        Object object = new ReplaySubject$ReplaySizeAndTimeBoundBuffer(Integer.MAX_VALUE, Long.MAX_VALUE, Schedulers.immediate());
        object = new ReplaySubject$ReplayState(object);
        return new ReplaySubject<T>(object);
    }

    public static <T> ReplaySubject<T> createWithSize(int n2) {
        Object object = new ReplaySubject$ReplaySizeBoundBuffer(n2);
        object = new ReplaySubject$ReplayState(object);
        return new ReplaySubject<T>(object);
    }

    public static <T> ReplaySubject<T> createWithTime(long l2, TimeUnit timeUnit, Scheduler scheduler) {
        return ReplaySubject.createWithTimeAndSize(l2, timeUnit, Integer.MAX_VALUE, scheduler);
    }

    public static <T> ReplaySubject<T> createWithTimeAndSize(long l2, TimeUnit timeUnit, int n2, Scheduler scheduler) {
        Object object = new ReplaySubject$ReplaySizeAndTimeBoundBuffer(n2, timeUnit.toMillis(l2), scheduler);
        object = new ReplaySubject$ReplayState(object);
        return new ReplaySubject<T>(object);
    }

    ReplaySubject(ReplaySubject$ReplayState<T> replaySubject$ReplayState) {
        super(replaySubject$ReplayState);
        this.state = replaySubject$ReplayState;
    }

    @Override
    public final void onNext(T t2) {
        this.state.onNext(t2);
    }

    @Override
    public final void onError(Throwable throwable) {
        this.state.onError(throwable);
    }

    @Override
    public final void onCompleted() {
        this.state.onCompleted();
    }

    final int subscriberCount() {
        return ((ReplaySubject$ReplayProducer[])this.state.get()).length;
    }

    @Override
    public final boolean hasObservers() {
        return ((ReplaySubject$ReplayProducer[])this.state.get()).length != 0;
    }

    @Beta
    public final boolean hasThrowable() {
        return this.state.isTerminated() && this.state.buffer.error() != null;
    }

    @Beta
    public final boolean hasCompleted() {
        return this.state.isTerminated() && this.state.buffer.error() == null;
    }

    @Beta
    public final Throwable getThrowable() {
        if (this.state.isTerminated()) {
            return this.state.buffer.error();
        }
        return null;
    }

    @Beta
    public final int size() {
        return this.state.buffer.size();
    }

    @Beta
    public final boolean hasAnyValue() {
        return !this.state.buffer.isEmpty();
    }

    @Beta
    public final boolean hasValue() {
        return this.hasAnyValue();
    }

    @Beta
    public final T[] getValues(T[] TArray) {
        return this.state.buffer.toArray(TArray);
    }

    @Beta
    public final Object[] getValues() {
        Object[] objectArray = this.getValues(EMPTY_ARRAY);
        if (objectArray == EMPTY_ARRAY) {
            return new Object[0];
        }
        return objectArray;
    }

    @Beta
    public final T getValue() {
        return this.state.buffer.last();
    }
}

