/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.subjects;

import com.zoyi.rx.Observable$OnSubscribe;
import com.zoyi.rx.annotations.Beta;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.NotificationLite;
import com.zoyi.rx.subjects.BehaviorSubject$1;
import com.zoyi.rx.subjects.Subject;
import com.zoyi.rx.subjects.SubjectSubscriptionManager;
import com.zoyi.rx.subjects.SubjectSubscriptionManager$SubjectObserver;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public final class BehaviorSubject<T>
extends Subject<T, T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final SubjectSubscriptionManager<T> state;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> BehaviorSubject<T> create() {
        return BehaviorSubject.create(null, false);
    }

    public static <T> BehaviorSubject<T> create(T t2) {
        return BehaviorSubject.create(t2, true);
    }

    private static <T> BehaviorSubject<T> create(T t2, boolean bl) {
        SubjectSubscriptionManager subjectSubscriptionManager = new SubjectSubscriptionManager();
        if (bl) {
            subjectSubscriptionManager.setLatest(NotificationLite.instance().next(t2));
        }
        subjectSubscriptionManager.onAdded = new BehaviorSubject$1(subjectSubscriptionManager);
        subjectSubscriptionManager.onTerminated = subjectSubscriptionManager.onAdded;
        return new BehaviorSubject(subjectSubscriptionManager, subjectSubscriptionManager);
    }

    protected BehaviorSubject(Observable$OnSubscribe<T> observable$OnSubscribe, SubjectSubscriptionManager<T> subjectSubscriptionManager) {
        super(observable$OnSubscribe);
        this.state = subjectSubscriptionManager;
    }

    @Override
    public final void onCompleted() {
        Object object = this.state.getLatest();
        if (object == null || this.state.active) {
            object = this.nl.completed();
            for (SubjectSubscriptionManager$SubjectObserver subjectSubscriptionManager$SubjectObserver : this.state.terminate(object)) {
                subjectSubscriptionManager$SubjectObserver.emitNext(object, this.state.nl);
            }
        }
    }

    @Override
    public final void onError(Throwable object) {
        ArrayList<Throwable> arrayList = this.state.getLatest();
        if (arrayList == null || this.state.active) {
            object = this.nl.error((Throwable)object);
            arrayList = null;
            for (SubjectSubscriptionManager$SubjectObserver subjectSubscriptionManager$SubjectObserver : this.state.terminate(object)) {
                try {
                    subjectSubscriptionManager$SubjectObserver.emitNext(object, this.state.nl);
                }
                catch (Throwable throwable) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Throwable>();
                    }
                    arrayList.add(throwable);
                }
            }
            Exceptions.throwIfAny((List<? extends Throwable>)arrayList);
        }
    }

    @Override
    public final void onNext(T object) {
        SubjectSubscriptionManager$SubjectObserver<T>[] subjectSubscriptionManager$SubjectObserverArray = this.state.getLatest();
        if (subjectSubscriptionManager$SubjectObserverArray == null || this.state.active) {
            object = this.nl.next(object);
            for (SubjectSubscriptionManager$SubjectObserver subjectSubscriptionManager$SubjectObserver : this.state.next(object)) {
                subjectSubscriptionManager$SubjectObserver.emitNext(object, this.state.nl);
            }
        }
    }

    final int subscriberCount() {
        return this.state.observers().length;
    }

    @Override
    public final boolean hasObservers() {
        return this.state.observers().length > 0;
    }

    @Beta
    public final boolean hasValue() {
        Object object = this.state.getLatest();
        return this.nl.isNext(object);
    }

    @Beta
    public final boolean hasThrowable() {
        Object object = this.state.getLatest();
        return this.nl.isError(object);
    }

    @Beta
    public final boolean hasCompleted() {
        Object object = this.state.getLatest();
        return this.nl.isCompleted(object);
    }

    @Beta
    public final T getValue() {
        Object object = this.state.getLatest();
        if (this.nl.isNext(object)) {
            return this.nl.getValue(object);
        }
        return null;
    }

    @Beta
    public final Throwable getThrowable() {
        Object object = this.state.getLatest();
        if (this.nl.isError(object)) {
            return this.nl.getError(object);
        }
        return null;
    }

    @Beta
    public final T[] getValues(T[] objectArray) {
        Object object = this.state.getLatest();
        if (this.nl.isNext(object)) {
            if (objectArray.length == 0) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), 1);
            }
            objectArray[0] = this.nl.getValue(object);
            if (objectArray.length > 1) {
                objectArray[1] = null;
            }
        } else if (objectArray.length > 0) {
            objectArray[0] = null;
        }
        return objectArray;
    }

    @Beta
    public final Object[] getValues() {
        Object[] objectArray = this.getValues(EMPTY_ARRAY);
        if (objectArray == EMPTY_ARRAY) {
            return new Object[0];
        }
        return objectArray;
    }
}

