/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.observers;

import com.zoyi.rx.Notification;
import com.zoyi.rx.Observer;
import com.zoyi.rx.exceptions.CompositeException;
import com.zoyi.rx.observers.TestObserver$1;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class TestObserver<T>
implements Observer<T> {
    private final Observer<T> delegate;
    private final List<T> onNextEvents = new ArrayList<T>();
    private final List<Throwable> onErrorEvents = new ArrayList<Throwable>();
    private final List<Notification<T>> onCompletedEvents = new ArrayList<Notification<T>>();
    private static final Observer<Object> INERT = new TestObserver$1();

    public TestObserver(Observer<T> observer) {
        this.delegate = observer;
    }

    public TestObserver() {
        this.delegate = INERT;
    }

    @Override
    public void onCompleted() {
        this.onCompletedEvents.add(Notification.createOnCompleted());
        this.delegate.onCompleted();
    }

    public List<Notification<T>> getOnCompletedEvents() {
        return Collections.unmodifiableList(this.onCompletedEvents);
    }

    @Override
    public void onError(Throwable throwable) {
        this.onErrorEvents.add(throwable);
        this.delegate.onError(throwable);
    }

    public List<Throwable> getOnErrorEvents() {
        return Collections.unmodifiableList(this.onErrorEvents);
    }

    @Override
    public void onNext(T t2) {
        this.onNextEvents.add(t2);
        this.delegate.onNext(t2);
    }

    public List<T> getOnNextEvents() {
        return Collections.unmodifiableList(this.onNextEvents);
    }

    public List<Object> getEvents() {
        ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
        arrayList.add(this.onNextEvents);
        arrayList.add(this.onErrorEvents);
        arrayList.add(this.onCompletedEvents);
        return Collections.unmodifiableList(arrayList);
    }

    public void assertReceivedOnNext(List<T> list) {
        if (this.onNextEvents.size() != list.size()) {
            this.assertionError("Number of items does not match. Provided: " + list.size() + "  Actual: " + this.onNextEvents.size() + ".\nProvided values: " + list + "\nActual values: " + this.onNextEvents + "\n");
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            T t2 = list.get(i2);
            T t3 = this.onNextEvents.get(i2);
            if (t2 == null) {
                if (t3 == null) continue;
                this.assertionError("Value at index: " + i2 + " expected to be [null] but was: [" + t3 + "]\n");
                continue;
            }
            if (t2.equals(t3)) continue;
            this.assertionError("Value at index: " + i2 + " expected to be [" + t2 + "] (" + t2.getClass().getSimpleName() + ") but was: [" + t3 + "] (" + (t3 != null ? t3.getClass().getSimpleName() : "null") + ")\n");
        }
    }

    public void assertTerminalEvent() {
        if (this.onErrorEvents.size() > 1) {
            this.assertionError("Too many onError events: " + this.onErrorEvents.size());
        }
        if (this.onCompletedEvents.size() > 1) {
            this.assertionError("Too many onCompleted events: " + this.onCompletedEvents.size());
        }
        if (this.onCompletedEvents.size() == 1 && this.onErrorEvents.size() == 1) {
            this.assertionError("Received both an onError and onCompleted. Should be one or the other.");
        }
        if (this.onCompletedEvents.isEmpty() && this.onErrorEvents.isEmpty()) {
            this.assertionError("No terminal events received.");
        }
    }

    final void assertionError(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 32);
        stringBuilder.append(string).append(" (");
        int n2 = this.onCompletedEvents.size();
        stringBuilder.append(n2).append(" completion");
        if (n2 != 1) {
            stringBuilder.append('s');
        }
        stringBuilder.append(')');
        if (!this.onErrorEvents.isEmpty()) {
            n2 = this.onErrorEvents.size();
            stringBuilder.append(" (+").append(n2).append(" error");
            if (n2 != 1) {
                stringBuilder.append('s');
            }
            stringBuilder.append(')');
        }
        AssertionError assertionError = new AssertionError((Object)stringBuilder.toString());
        if (!this.onErrorEvents.isEmpty()) {
            if (this.onErrorEvents.size() == 1) {
                ((Throwable)((Object)assertionError)).initCause(this.onErrorEvents.get(0));
            } else {
                ((Throwable)((Object)assertionError)).initCause(new CompositeException(this.onErrorEvents));
            }
        }
        throw assertionError;
    }
}

