/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.observers;

import com.zoyi.rx.CompletableSubscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.annotations.Experimental;
import com.zoyi.rx.observers.AsyncCompletableSubscriber$Unsubscribed;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.concurrent.atomic.AtomicReference;

@Experimental
public abstract class AsyncCompletableSubscriber
implements CompletableSubscriber,
Subscription {
    static final AsyncCompletableSubscriber$Unsubscribed UNSUBSCRIBED = new AsyncCompletableSubscriber$Unsubscribed();
    private final AtomicReference<Subscription> upstream = new AtomicReference();

    @Override
    public final void onSubscribe(Subscription subscription) {
        if (!this.upstream.compareAndSet(null, subscription)) {
            subscription.unsubscribe();
            if (this.upstream.get() != UNSUBSCRIBED) {
                RxJavaHooks.onError(new IllegalStateException("Subscription already set!"));
                return;
            }
        } else {
            this.onStart();
        }
    }

    protected void onStart() {
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.upstream.get() == UNSUBSCRIBED;
    }

    protected final void clear() {
        this.upstream.set(UNSUBSCRIBED);
    }

    @Override
    public final void unsubscribe() {
        Subscription subscription = this.upstream.get();
        if (subscription != UNSUBSCRIBED && (subscription = this.upstream.getAndSet(UNSUBSCRIBED)) != null && subscription != UNSUBSCRIBED) {
            subscription.unsubscribe();
        }
    }
}

