/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.observables;

import com.zoyi.rx.Observer;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.observables.SyncOnSubscribe;
import com.zoyi.rx.plugins.RxJavaHooks;
import java.util.concurrent.atomic.AtomicLong;

final class SyncOnSubscribe$SubscriptionProducer<S, T>
extends AtomicLong
implements Observer<T>,
Producer,
Subscription {
    private static final long serialVersionUID = -3736864024352728072L;
    private final Subscriber<? super T> actualSubscriber;
    private final SyncOnSubscribe<S, T> parent;
    private boolean onNextCalled;
    private boolean hasTerminated;
    private S state;

    SyncOnSubscribe$SubscriptionProducer(Subscriber<? super T> subscriber, SyncOnSubscribe<S, T> syncOnSubscribe, S s2) {
        this.actualSubscriber = subscriber;
        this.parent = syncOnSubscribe;
        this.state = s2;
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.get() < 0L;
    }

    @Override
    public final void unsubscribe() {
        long l2;
        do {
            l2 = this.get();
            if (!this.compareAndSet(0L, -1L)) continue;
            this.doUnsubscribe();
            return;
        } while (!this.compareAndSet(l2, -2L));
    }

    private boolean tryUnsubscribe() {
        if (this.hasTerminated || this.get() < -1L) {
            this.set(-1L);
            this.doUnsubscribe();
            return true;
        }
        return false;
    }

    private void doUnsubscribe() {
        try {
            this.parent.onUnsubscribe(this.state);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exceptions.throwIfFatal(throwable);
            RxJavaHooks.onError(throwable2);
            return;
        }
    }

    @Override
    public final void request(long l2) {
        if (l2 > 0L && BackpressureUtils.getAndAddRequest(this, l2) == 0L) {
            if (l2 == Long.MAX_VALUE) {
                this.fastpath();
                return;
            }
            this.slowPath(l2);
        }
    }

    private void fastpath() {
        SyncOnSubscribe<S, T> syncOnSubscribe = this.parent;
        Subscriber<? super T> subscriber = this.actualSubscriber;
        do {
            try {
                this.onNextCalled = false;
                this.nextIteration(syncOnSubscribe);
            }
            catch (Throwable throwable) {
                this.handleThrownError(subscriber, throwable);
                return;
            }
        } while (!this.tryUnsubscribe());
    }

    private void handleThrownError(Subscriber<? super T> subscriber, Throwable throwable) {
        if (this.hasTerminated) {
            RxJavaHooks.onError(throwable);
            return;
        }
        this.hasTerminated = true;
        subscriber.onError(throwable);
        this.unsubscribe();
    }

    private void slowPath(long l2) {
        SyncOnSubscribe<S, T> syncOnSubscribe = this.parent;
        Subscriber<? super T> subscriber = this.actualSubscriber;
        long l3 = l2;
        do {
            long l4 = l3;
            do {
                try {
                    this.onNextCalled = false;
                    this.nextIteration(syncOnSubscribe);
                }
                catch (Throwable throwable) {
                    this.handleThrownError(subscriber, throwable);
                    return;
                }
                if (this.tryUnsubscribe()) {
                    return;
                }
                if (!this.onNextCalled) continue;
                --l4;
            } while (l4 != 0L);
        } while ((l3 = this.addAndGet(-l3)) > 0L);
        this.tryUnsubscribe();
    }

    private void nextIteration(SyncOnSubscribe<S, T> syncOnSubscribe) {
        this.state = syncOnSubscribe.next(this.state, this);
    }

    @Override
    public final void onCompleted() {
        if (this.hasTerminated) {
            throw new IllegalStateException("Terminal event already emitted.");
        }
        this.hasTerminated = true;
        if (!this.actualSubscriber.isUnsubscribed()) {
            this.actualSubscriber.onCompleted();
        }
    }

    @Override
    public final void onError(Throwable throwable) {
        if (this.hasTerminated) {
            throw new IllegalStateException("Terminal event already emitted.");
        }
        this.hasTerminated = true;
        if (!this.actualSubscriber.isUnsubscribed()) {
            this.actualSubscriber.onError(throwable);
        }
    }

    @Override
    public final void onNext(T t2) {
        if (this.onNextCalled) {
            throw new IllegalStateException("onNext called multiple times!");
        }
        this.onNextCalled = true;
        this.actualSubscriber.onNext(t2);
    }
}

